/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContextImpl;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;

class MethodAsMapBuilder {
    String indexDescription;
    MethodComponent methodComponent;
    Map<String, Object> methodAsMap;
    KNNMethodConfigContext knnMethodConfigContext;
    QuantizationConfig quantizationConfig;

    MethodAsMapBuilder addParameter(String parameterName, String prefix, String suffix) {
        Object value;
        this.indexDescription = this.indexDescription + prefix;
        Map methodParameters = (Map)this.methodAsMap.get("parameters");
        Parameter<?> parameter = this.methodComponent.getParameters().get(parameterName);
        Object object = value = methodParameters.containsKey(parameterName) ? methodParameters.get(parameterName) : parameter.getDefaultValue();
        if (parameter instanceof Parameter.MethodComponentContextParameter) {
            MethodComponentContext subMethodComponentContext = (MethodComponentContext)value;
            MethodComponent subMethodComponent = ((Parameter.MethodComponentContextParameter)parameter).getMethodComponent(subMethodComponentContext.getName());
            KNNLibraryIndexingContext knnLibraryIndexingContext = subMethodComponent.getKNNLibraryIndexingContext(subMethodComponentContext, this.knnMethodConfigContext);
            Map<String, Object> subMethodAsMap = knnLibraryIndexingContext.getLibraryParameters();
            if (subMethodAsMap != null && !subMethodAsMap.isEmpty() && subMethodAsMap.containsKey("index_description")) {
                this.indexDescription = this.indexDescription + String.valueOf(subMethodAsMap.get("index_description"));
                subMethodAsMap.remove("index_description");
            }
            if (this.quantizationConfig == null || this.quantizationConfig == QuantizationConfig.EMPTY) {
                this.quantizationConfig = knnLibraryIndexingContext.getQuantizationConfig();
            }
            methodParameters.put(parameterName, subMethodAsMap);
        } else {
            this.indexDescription = this.indexDescription + String.valueOf(value);
        }
        this.indexDescription = this.indexDescription + suffix;
        return this;
    }

    KNNLibraryIndexingContext build() {
        this.methodAsMap.put("index_description", this.indexDescription);
        return KNNLibraryIndexingContextImpl.builder().parameters(this.methodAsMap).quantizationConfig(this.quantizationConfig).build();
    }

    static MethodAsMapBuilder builder(String baseDescription, MethodComponent methodComponent, MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        HashMap<String, Object> initialMap = new HashMap<String, Object>();
        initialMap.put("name", methodComponent.getName());
        initialMap.put("parameters", MethodComponent.getParameterMapWithDefaultsAdded(methodComponentContext, methodComponent, knnMethodConfigContext));
        return new MethodAsMapBuilder(baseDescription, methodComponent, initialMap, knnMethodConfigContext, QuantizationConfig.EMPTY);
    }

    @Generated
    public MethodAsMapBuilder(String indexDescription, MethodComponent methodComponent, Map<String, Object> methodAsMap, KNNMethodConfigContext knnMethodConfigContext, QuantizationConfig quantizationConfig) {
        this.indexDescription = indexDescription;
        this.methodComponent = methodComponent;
        this.methodAsMap = methodAsMap;
        this.knnMethodConfigContext = knnMethodConfigContext;
        this.quantizationConfig = quantizationConfig;
    }
}

