/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class VolumeData extends Resource {

	public VolumeData(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the VolumeDataComposite of this VolumeData instance
	 *
	 * @return filled with the VolumeDataComposite of this VolumeData instance.
	 * @throws Lib3MFException
	 */
	public VolumeDataComposite getComposite() throws Lib3MFException {
		Pointer bufferTheCompositeData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_getcomposite.invokeInt(new java.lang.Object[]{mHandle, bufferTheCompositeData}));
		Pointer valueTheCompositeData = bufferTheCompositeData.getPointer(0);
		VolumeDataComposite theCompositeData = null;
		if (valueTheCompositeData != Pointer.NULL) {
		  theCompositeData = mWrapper.PolymorphicFactory(valueTheCompositeData, VolumeDataComposite.class);
		}
		return theCompositeData;
	}

	/**
	 * Creates a new VolumeDataComposite for this VolumeData instance
	 *
	 * @return The new VolumeDataComposite of this VolumeData instance.
	 * @throws Lib3MFException
	 */
	public VolumeDataComposite createNewComposite() throws Lib3MFException {
		Pointer bufferTheCompositeData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_createnewcomposite.invokeInt(new java.lang.Object[]{mHandle, bufferTheCompositeData}));
		Pointer valueTheCompositeData = bufferTheCompositeData.getPointer(0);
		VolumeDataComposite theCompositeData = null;
		if (valueTheCompositeData == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheCompositeData was a null pointer");
		}
		theCompositeData = mWrapper.PolymorphicFactory(valueTheCompositeData, VolumeDataComposite.class);
		return theCompositeData;
	}

	/**
	 * Removes the VolumeDataComposite of this VolumeData instance
	 *
	 * @throws Lib3MFException
	 */
	public void removeComposite() throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_removecomposite.invokeInt(new java.lang.Object[]{mHandle}));
	}

	/**
	 * Returns the VolumeDataColor of this VolumeData instance
	 *
	 * @return filled with the VolumeDataColor of this VolumeData instance.
	 * @throws Lib3MFException
	 */
	public VolumeDataColor getColor() throws Lib3MFException {
		Pointer bufferTheColorData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_getcolor.invokeInt(new java.lang.Object[]{mHandle, bufferTheColorData}));
		Pointer valueTheColorData = bufferTheColorData.getPointer(0);
		VolumeDataColor theColorData = null;
		if (valueTheColorData != Pointer.NULL) {
		  theColorData = mWrapper.PolymorphicFactory(valueTheColorData, VolumeDataColor.class);
		}
		return theColorData;
	}

	/**
	 * Creates a new VolumeDataColor for this VolumeData instance
	 *
	 * @param theFunction Function used in this element
	 * @return The new VolumeDataColor of this VolumeData instance.
	 * @throws Lib3MFException
	 */
	public VolumeDataColor createNewColor(Function theFunction) throws Lib3MFException {
		Pointer theFunctionHandle = null;
		if (theFunction != null) {
			theFunctionHandle = theFunction.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheFunction is a null value.");
		}
		Pointer bufferTheColorData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_createnewcolor.invokeInt(new java.lang.Object[]{mHandle, theFunctionHandle, bufferTheColorData}));
		Pointer valueTheColorData = bufferTheColorData.getPointer(0);
		VolumeDataColor theColorData = null;
		if (valueTheColorData == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheColorData was a null pointer");
		}
		theColorData = mWrapper.PolymorphicFactory(valueTheColorData, VolumeDataColor.class);
		return theColorData;
	}

	/**
	 * Removes the VolumeDataColor of this VolumeData instance
	 *
	 * @throws Lib3MFException
	 */
	public void removeColor() throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_removecolor.invokeInt(new java.lang.Object[]{mHandle}));
	}

	/**
	 * Returns the number of VolumeDataProperty
	 *
	 * @return the number of VolumeDataProperty-elements within this VolumeData
	 * @throws Lib3MFException
	 */
	public int getPropertyCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_getpropertycount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Returns the VolumeDataProperty at a given Index
	 *
	 * @param index the index of the VolumeDataProperty to be returned.
	 * @return the VolumeDataProperty at the given index.
	 * @throws Lib3MFException
	 */
	public VolumeDataProperty getProperty(int index) throws Lib3MFException {
		Pointer bufferTheVolumeDataProperty = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_getproperty.invokeInt(new java.lang.Object[]{mHandle, index, bufferTheVolumeDataProperty}));
		Pointer valueTheVolumeDataProperty = bufferTheVolumeDataProperty.getPointer(0);
		VolumeDataProperty theVolumeDataProperty = null;
		if (valueTheVolumeDataProperty == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheVolumeDataProperty was a null pointer");
		}
		theVolumeDataProperty = mWrapper.PolymorphicFactory(valueTheVolumeDataProperty, VolumeDataProperty.class);
		return theVolumeDataProperty;
	}

	/**
	 * Adds a new VolumeDataProperty from a Function
	 *
	 * @param name the qualified name (namespace+name) of the Property
	 * @param theFunction Function used in this element
	 * @return the newly created VolumeDataProperty.
	 * @throws Lib3MFException
	 */
	public VolumeDataProperty addPropertyFromFunction(String name, Function theFunction) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		Pointer theFunctionHandle = null;
		if (theFunction != null) {
			theFunctionHandle = theFunction.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheFunction is a null value.");
		}
		Pointer bufferTheVolumeDataProperty = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_addpropertyfromfunction.invokeInt(new java.lang.Object[]{mHandle, bufferName, theFunctionHandle, bufferTheVolumeDataProperty}));
		Pointer valueTheVolumeDataProperty = bufferTheVolumeDataProperty.getPointer(0);
		VolumeDataProperty theVolumeDataProperty = null;
		if (valueTheVolumeDataProperty == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheVolumeDataProperty was a null pointer");
		}
		theVolumeDataProperty = mWrapper.PolymorphicFactory(valueTheVolumeDataProperty, VolumeDataProperty.class);
		return theVolumeDataProperty;
	}

	/**
	 * Removes the VolumeDataProperty with a given index
	 *
	 * @param index the index of the VolumeDataProperty to be removed.
	 * @throws Lib3MFException
	 */
	public void removeProperty(int index) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_volumedata_removeproperty.invokeInt(new java.lang.Object[]{mHandle, index}));
	}


}

