/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Reader extends Base {

	public Reader(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Reads a model from a file. The file type is specified by the Model Reader class
	 *
	 * @param filename Filename to read from
	 * @throws Lib3MFException
	 */
	public void readFromFile(String filename) throws Lib3MFException {
		byte[] bytesFilename = filename.getBytes(StandardCharsets.UTF_8);
		Memory bufferFilename = new Memory(bytesFilename.length + 1);
		bufferFilename.write(0, bytesFilename, 0, bytesFilename.length);
		bufferFilename.setByte(bytesFilename.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_readfromfile.invokeInt(new java.lang.Object[]{mHandle, bufferFilename}));
	}

	/**
	 * Reads a model from a memory buffer.
	 *
	 * @param buffer Buffer to read from
	 * @throws Lib3MFException
	 */
	public void readFromBuffer(byte[] buffer) throws Lib3MFException {
		Pointer bufferBuffer = new Memory(Math.max(1, 1 * buffer.length));
		for (int i = 0; i < buffer.length; i++) {
		  bufferBuffer.setByte(1 * i, buffer[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_reader_readfrombuffer.invokeInt(new java.lang.Object[]{mHandle, (long) buffer.length, bufferBuffer}));
	}

	/**
	 * Reads a model and from the data provided by a callback function
	 *
	 * @param theReadCallback Callback to call for reading a data chunk
	 * @param streamSize number of bytes the callback returns
	 * @param theSeekCallback Callback to call for seeking in the stream.
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void readFromCallback(Lib3MFWrapper.ReadCallback theReadCallback, long streamSize, Lib3MFWrapper.SeekCallback theSeekCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_reader_readfromcallback.invokeInt(new java.lang.Object[]{mHandle, theReadCallback, streamSize, theSeekCallback, userData}));
	}

	/**
	 * Set the progress callback for calls to this writer
	 *
	 * @param progressCallback pointer to the callback function.
	 * @param userData pointer to arbitrary user data that is passed without modification to the callback.
	 * @throws Lib3MFException
	 */
	public void setProgressCallback(Lib3MFWrapper.ProgressCallback progressCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_reader_setprogresscallback.invokeInt(new java.lang.Object[]{mHandle, progressCallback, userData}));
	}

	/**
	 * Adds a relationship type which shall be read as attachment in memory while loading
	 *
	 * @param relationShipType String of the relationship type
	 * @throws Lib3MFException
	 */
	public void addRelationToRead(String relationShipType) throws Lib3MFException {
		byte[] bytesRelationShipType = relationShipType.getBytes(StandardCharsets.UTF_8);
		Memory bufferRelationShipType = new Memory(bytesRelationShipType.length + 1);
		bufferRelationShipType.write(0, bytesRelationShipType, 0, bytesRelationShipType.length);
		bufferRelationShipType.setByte(bytesRelationShipType.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_addrelationtoread.invokeInt(new java.lang.Object[]{mHandle, bufferRelationShipType}));
	}

	/**
	 * Removes a relationship type which shall be read as attachment in memory while loading
	 *
	 * @param relationShipType String of the relationship type
	 * @throws Lib3MFException
	 */
	public void removeRelationToRead(String relationShipType) throws Lib3MFException {
		byte[] bytesRelationShipType = relationShipType.getBytes(StandardCharsets.UTF_8);
		Memory bufferRelationShipType = new Memory(bytesRelationShipType.length + 1);
		bufferRelationShipType.write(0, bytesRelationShipType, 0, bytesRelationShipType.length);
		bufferRelationShipType.setByte(bytesRelationShipType.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_removerelationtoread.invokeInt(new java.lang.Object[]{mHandle, bufferRelationShipType}));
	}

	/**
	 * Activates (deactivates) the strict mode of the reader.
	 *
	 * @param strictModeActive flag whether strict mode is active or not.
	 * @throws Lib3MFException
	 */
	public void setStrictModeActive(boolean strictModeActive) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_reader_setstrictmodeactive.invokeInt(new java.lang.Object[]{mHandle, strictModeActive}));
	}

	/**
	 * Queries whether the strict mode of the reader is active or not
	 *
	 * @return returns flag whether strict mode is active or not.
	 * @throws Lib3MFException
	 */
	public boolean getStrictModeActive() throws Lib3MFException {
		Pointer bufferStrictModeActive = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_getstrictmodeactive.invokeInt(new java.lang.Object[]{mHandle, bufferStrictModeActive}));
		return bufferStrictModeActive.getByte(0) != 0;
	}

	/**
	 * Returns Warning and Error Information of the read process
	 *
	 * @param index Index of the Warning. Valid values are 0 to WarningCount - 1
	 * @return GetWarning Result Tuple
	 * @throws Lib3MFException
	 */
	public GetWarningResult getWarning(int index) throws Lib3MFException {
		Pointer bufferErrorCode = new Memory(4);
		Pointer bytesNeededWarning = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_getwarning.invokeInt(new java.lang.Object[]{mHandle, index, bufferErrorCode, 0, bytesNeededWarning, null}));
		int sizeWarning = bytesNeededWarning.getInt(0);
		Pointer bufferWarning = new Memory(sizeWarning);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_getwarning.invokeInt(new java.lang.Object[]{mHandle, index, bufferErrorCode, sizeWarning, bytesNeededWarning, bufferWarning}));
		GetWarningResult returnTuple = new GetWarningResult();
		returnTuple.ErrorCode = bufferErrorCode.getInt(0);
		returnTuple.Warning = new String(bufferWarning.getByteArray(0, sizeWarning - 1), StandardCharsets.UTF_8);
		return returnTuple;
	}

	public static class GetWarningResult {
		/**
		 * filled with the error code of the warning
		 */
		public int ErrorCode;

		/**
		 * the message of the warning
		 */
		public String Warning;

	}
	/**
	 * Returns Warning and Error Count of the read process
	 *
	 * @return filled with the count of the occurred warnings.
	 * @throws Lib3MFException
	 */
	public int getWarningCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_getwarningcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Registers a callback to deal with key wrapping mechanism from keystore
	 *
	 * @param consumerID The ConsumerID to register for
	 * @param theCallback The callback used to decrypt data key
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void addKeyWrappingCallback(String consumerID, Lib3MFWrapper.KeyWrappingCallback theCallback, Pointer userData) throws Lib3MFException {
		byte[] bytesConsumerID = consumerID.getBytes(StandardCharsets.UTF_8);
		Memory bufferConsumerID = new Memory(bytesConsumerID.length + 1);
		bufferConsumerID.write(0, bytesConsumerID, 0, bytesConsumerID.length);
		bufferConsumerID.setByte(bytesConsumerID.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_reader_addkeywrappingcallback.invokeInt(new java.lang.Object[]{mHandle, bufferConsumerID, theCallback, userData}));
	}

	/**
	 * Registers a callback to deal with encryption of content
	 *
	 * @param theCallback The callback used to encrypt content
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void setContentEncryptionCallback(Lib3MFWrapper.ContentEncryptionCallback theCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_reader_setcontentencryptioncallback.invokeInt(new java.lang.Object[]{mHandle, theCallback, userData}));
	}


}

