/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedCrossJoin
extends SqmCrossJoin
implements SqmTreatedJoin {
    private final SqmCrossJoin wrappedPath;
    private final SqmEntityDomainType treatTarget;

    private SqmTreatedCrossJoin(NavigablePath navigablePath, SqmCrossJoin<?> wrappedPath, SqmEntityDomainType<?> treatTarget, String alias) {
        super(navigablePath, (SqmEntityDomainType)wrappedPath.getReferencedPathSource().getPathType(), alias, wrappedPath.getRoot());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedCrossJoin copy(SqmCopyContext context) {
        SqmTreatedCrossJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedCrossJoin path = context.registerCopy(this, new SqmTreatedCrossJoin(this.getNavigablePath(), (SqmCrossJoin<?>)this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias()));
        this.copyTo(path, context);
        return path;
    }

    public SqmEntityDomainType getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmEntityDomainType getModel() {
        return this.treatTarget;
    }

    @Override
    public SqmPath getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmBindableType getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmEntityDomainType getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedCrossJoin)) return false;
        SqmTreatedCrossJoin that = (SqmTreatedCrossJoin)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getName(), that.treatTarget.getName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getName(), this.wrappedPath.getNavigablePath());
    }

    @Override
    public SqmTreatedCrossJoin treatAs(Class treatJavaType, String alias) {
        return super.treatAs(treatJavaType, alias);
    }

    @Override
    public SqmTreatedCrossJoin treatAs(EntityDomainType treatTarget, String alias) {
        return super.treatAs(treatTarget, alias);
    }

    @Override
    public SqmTreatedCrossJoin treatAs(Class treatAsType) {
        return super.treatAs(treatAsType);
    }

    @Override
    public SqmTreatedCrossJoin treatAs(EntityDomainType treatAsType) {
        return super.treatAs(treatAsType);
    }
}

