/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.dom.saml.v2.protocol.RequestedAuthnContextType;

public class SAML2RequestedAuthnContextBuilder {
    private final RequestedAuthnContextType requestedAuthnContextType = new RequestedAuthnContextType();
    private AuthnContextComparisonType comparison;
    private List<String> requestedAuthnContextClassRefList = new LinkedList<String>();
    private List<String> requestedAuthnContextDeclRefList = new LinkedList<String>();

    public SAML2RequestedAuthnContextBuilder setComparison(AuthnContextComparisonType comparison) {
        this.comparison = comparison;
        return this;
    }

    public SAML2RequestedAuthnContextBuilder addAuthnContextClassRef(String authnContextClassRef) {
        this.requestedAuthnContextClassRefList.add(authnContextClassRef);
        return this;
    }

    public SAML2RequestedAuthnContextBuilder addAuthnContextDeclRef(String authnContextDeclRef) {
        this.requestedAuthnContextDeclRefList.add(authnContextDeclRef);
        return this;
    }

    public RequestedAuthnContextType build() {
        if (this.comparison != null) {
            this.requestedAuthnContextType.setComparison(this.comparison);
        }
        for (String requestedAuthnContextClassRef : this.requestedAuthnContextClassRefList) {
            if (requestedAuthnContextClassRef == null || requestedAuthnContextClassRef.isEmpty()) continue;
            this.requestedAuthnContextType.addAuthnContextClassRef(requestedAuthnContextClassRef);
        }
        for (String requestedAuthnContextDeclRef : this.requestedAuthnContextDeclRefList) {
            if (requestedAuthnContextDeclRef == null || requestedAuthnContextDeclRef.isEmpty()) continue;
            this.requestedAuthnContextType.addAuthnContextDeclRef(requestedAuthnContextDeclRef);
        }
        return this.requestedAuthnContextType;
    }
}

