/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingWindowBytesStore
extends WrappedStateStore<WindowStore<Bytes, byte[]>, byte[], byte[]>
implements WindowStore<Bytes, byte[]> {
    private final boolean retainDuplicates;
    InternalProcessorContext<?, ?> internalContext;
    private int seqnum = 0;
    private final ChangeLoggingKeySerializer keySerializer;

    ChangeLoggingWindowBytesStore(WindowStore<Bytes, byte[]> bytesStore, boolean retainDuplicates, ChangeLoggingKeySerializer keySerializer) {
        super(bytesStore);
        this.retainDuplicates = retainDuplicates;
        this.keySerializer = Objects.requireNonNull(keySerializer, "keySerializer");
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.internalContext = ProcessorContextUtils.asInternalProcessorContext(stateStoreContext);
        super.init(stateStoreContext, root);
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long from, long to) {
        return ((WindowStore)this.wrapped()).fetch(key, from, to);
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).backwardFetch(key, timeFrom, timeTo);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long to) {
        return ((WindowStore)this.wrapped()).fetch(keyFrom, keyTo, timeFrom, to);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        return ((WindowStore)this.wrapped()).all();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        return ((WindowStore)this.wrapped()).backwardAll();
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        return ((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo);
    }

    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        ((WindowStore)this.wrapped()).put(key, value, windowStartTimestamp);
        this.log(this.keySerializer.serialize(key, windowStartTimestamp, this.maybeUpdateSeqnumForDups()), value);
    }

    void log(Bytes key, byte[] value) {
        this.internalContext.logChange(this.name(), key, value, this.internalContext.timestamp(), ((WindowStore)this.wrapped()).getPosition());
    }

    private int maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
        return this.seqnum;
    }

    static interface ChangeLoggingKeySerializer {
        public Bytes serialize(Bytes var1, long var2, int var4);
    }
}

