/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter relabels the LabelObjects; the new labels are arranged
consecutively with consideration for the background value.


This filter takes the LabelObjects from the input and reassigns them
to the output by calling the PushLabelObject method, which by default,
attempts to reorganize the labels consecutively. The user can assign
an arbitrary value to the background; the filter will assign the
labels consecutively by skipping the background value.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::RelabelLabelMapFilter for the procedural interface

 itk::RelabelLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkRelabelLabelMapFilter.h
*/
public class RelabelLabelMapFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RelabelLabelMapFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RelabelLabelMapFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RelabelLabelMapFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RelabelLabelMapFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RelabelLabelMapFilter::~RelabelLabelMapFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RelabelLabelMapFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RelabelLabelMapFilter::RelabelLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RelabelLabelMapFilter() {
    this(SimpleITKJNI.new_RelabelLabelMapFilter(), true);
  }

  /**
Self&amp; itk::simple::RelabelLabelMapFilter::SetReverseOrdering(bool ReverseOrdering)
*/
public  void setReverseOrdering(boolean ReverseOrdering) {
    SimpleITKJNI.RelabelLabelMapFilter_setReverseOrdering(swigCPtr, this, ReverseOrdering);
  }

  /**
Self&amp; itk::simple::RelabelLabelMapFilter::ReverseOrderingOn()

Set the value of ReverseOrdering to true or false respectfully.

*/
public  void reverseOrderingOn() {
    SimpleITKJNI.RelabelLabelMapFilter_reverseOrderingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RelabelLabelMapFilter::ReverseOrderingOff()
*/
public  void reverseOrderingOff() {
    SimpleITKJNI.RelabelLabelMapFilter_reverseOrderingOff(swigCPtr, this);
  }

  /**
bool itk::simple::RelabelLabelMapFilter::GetReverseOrdering() const
*/
public  boolean getReverseOrdering() {
    return SimpleITKJNI.RelabelLabelMapFilter_getReverseOrdering(swigCPtr, this);
  }

  /**
std::string itk::simple::RelabelLabelMapFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RelabelLabelMapFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RelabelLabelMapFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RelabelLabelMapFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RelabelLabelMapFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RelabelLabelMapFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
