/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android;

import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;

public abstract class ProgressManagerAdapter {
    private static ProgressManagerAdapter ourInstance;

    public static void checkCanceled() {
        ProgressManagerAdapter instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public static void throwIfCancellation(Throwable t15) {
        ProgressManagerAdapter instance = ourInstance;
        if (instance == null) {
            ProgressManagerAdapter.throwIfCancellationException(t15);
        } else {
            instance.doThrowIfCancellation(t15);
        }
    }

    protected abstract void doCheckCanceled();

    protected void doThrowIfCancellation(Throwable t15) {
        ProgressManagerAdapter.throwIfCancellationException(t15);
    }

    private static void throwIfCancellationException(Throwable t15) {
        if (t15 instanceof CancellationException) {
            throw (CancellationException)t15;
        }
    }

    protected static void setInstance(ProgressManagerAdapter instance) {
        Preconditions.checkState(ourInstance == null);
        ourInstance = instance;
    }
}

