/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Iterator;
import org.stringtemplate.v4.misc.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Misc {
    public static final String newline = System.getProperty("line.separator");

    public static boolean referenceEquals(Object x15, Object y15) {
        return x15 == y15;
    }

    public static String join(Iterator<?> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String strip(String s15, int n15) {
        return s15.substring(n15, s15.length() - n15);
    }

    public static String trimOneStartingNewline(String s15) {
        if (s15.startsWith("\r\n")) {
            s15 = s15.substring(2);
        } else if (s15.startsWith("\n")) {
            s15 = s15.substring(1);
        }
        return s15;
    }

    public static String trimOneTrailingNewline(String s15) {
        if (s15.endsWith("\r\n")) {
            s15 = s15.substring(0, s15.length() - 2);
        } else if (s15.endsWith("\n")) {
            s15 = s15.substring(0, s15.length() - 1);
        }
        return s15;
    }

    public static String stripLastPathElement(String f15) {
        int slash = f15.lastIndexOf(47);
        if (slash < 0) {
            return f15;
        }
        return f15.substring(0, slash);
    }

    public static String getFileNameNoSuffix(String f15) {
        if (f15 == null) {
            return null;
        }
        f15 = Misc.getFileName(f15);
        return f15.substring(0, f15.lastIndexOf(46));
    }

    public static String getFileName(String fullFileName) {
        if (fullFileName == null) {
            return null;
        }
        File f15 = new File(fullFileName);
        return f15.getName();
    }

    public static String getParent(String name) {
        if (name == null) {
            return null;
        }
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            return name.substring(0, lastSlash);
        }
        if (lastSlash == 0) {
            return "/";
        }
        return "";
    }

    public static String getPrefix(String name) {
        String parent;
        if (name == null) {
            return "/";
        }
        String prefix = parent = Misc.getParent(name);
        if (!parent.endsWith("/")) {
            prefix = prefix + '/';
        }
        return prefix;
    }

    public static String replaceEscapes(String s15) {
        s15 = s15.replaceAll("\n", "\\\\n");
        s15 = s15.replaceAll("\r", "\\\\r");
        s15 = s15.replaceAll("\t", "\\\\t");
        return s15;
    }

    public static String replaceEscapedRightAngle(String s15) {
        StringBuilder buf = new StringBuilder();
        int i15 = 0;
        while (i15 < s15.length()) {
            char c15 = s15.charAt(i15);
            if (c15 == '<' && s15.substring(i15).startsWith("<\\\\>")) {
                buf.append("<\\\\>");
                i15 += "<\\\\>".length();
                continue;
            }
            if (c15 == '>' && s15.substring(i15).startsWith(">\\>")) {
                buf.append(">>");
                i15 += ">\\>".length();
                continue;
            }
            if (c15 == '\\' && s15.substring(i15).startsWith("\\>>") && !s15.substring(i15).startsWith("\\>>>")) {
                buf.append(">>");
                i15 += "\\>>".length();
                continue;
            }
            buf.append(c15);
            ++i15;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean urlExists(URL url) {
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jarURLConnection.getJarFileURL()});
                try {
                    boolean bl4 = urlClassLoader.findResource(jarURLConnection.getEntryName()) != null;
                    return bl4;
                }
                finally {
                    if (urlClassLoader instanceof Closeable) {
                        ((Closeable)urlClassLoader).close();
                    }
                }
            }
            InputStream is4 = null;
            try {
                is4 = url.openStream();
            }
            finally {
                if (is4 != null) {
                    is4.close();
                }
            }
            if (is4 == null) return false;
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static Coordinate getLineCharPosition(String s15, int index) {
        int line = 1;
        int charPos = 0;
        for (int p15 = 0; p15 < index; ++p15) {
            if (s15.charAt(p15) == '\n') {
                ++line;
                charPos = 0;
                continue;
            }
            ++charPos;
        }
        return new Coordinate(line, charPos);
    }
}

