/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STGroupString;
import org.stringtemplate.v4.debug.EvalExprEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.gui.JTreeASTModel;
import org.stringtemplate.v4.gui.JTreeSTModel;
import org.stringtemplate.v4.gui.JTreeScopeStackModel;
import org.stringtemplate.v4.gui.STViewFrame;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;
import org.stringtemplate.v4.misc.STRuntimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STViz {
    protected static final String WINDOWS_LINE_ENDINGS = "WINDOWS_LINE_ENDINGS";
    public EvalTemplateEvent root;
    public InterpEvent currentEvent;
    public InstanceScope currentScope;
    public List<InterpEvent> allEvents;
    public JTreeSTModel tmodel;
    public ErrorManager errMgr;
    public Interpreter interp;
    public String output;
    public List<String> trace;
    public List<STMessage> errors;
    public STViewFrame viewFrame;
    private final AtomicInteger updateDepth = new AtomicInteger();

    public STViz(ErrorManager errMgr, EvalTemplateEvent root, String output, Interpreter interp, List<String> trace, List<STMessage> errors) {
        this.errMgr = errMgr;
        this.currentEvent = root;
        this.currentScope = root.scope;
        this.output = output;
        this.interp = interp;
        this.allEvents = interp.getEvents();
        this.trace = trace;
        this.errors = errors;
    }

    public void open() {
        this.viewFrame = new STViewFrame();
        this.updateStack(this.currentScope, this.viewFrame);
        this.updateAttributes(this.currentScope, this.viewFrame);
        List<InterpEvent> events = this.currentScope.events;
        this.tmodel = new JTreeSTModel(this.interp, (EvalTemplateEvent)events.get(events.size() - 1));
        this.viewFrame.tree.setModel(this.tmodel);
        this.viewFrame.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                int depth = STViz.this.updateDepth.incrementAndGet();
                try {
                    if (depth != 1) {
                        return;
                    }
                    STViz.this.currentEvent = ((JTreeSTModel.Wrapper)STViz.this.viewFrame.tree.getLastSelectedPathComponent()).event;
                    STViz.this.currentScope = STViz.this.currentEvent.scope;
                    STViz.this.updateCurrentST(STViz.this.viewFrame);
                }
                finally {
                    STViz.this.updateDepth.decrementAndGet();
                }
            }
        });
        JTreeASTModel astModel = new JTreeASTModel(new CommonTreeAdaptor(), this.currentScope.st.impl.ast);
        this.viewFrame.ast.setModel(astModel);
        this.viewFrame.ast.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                int depth = STViz.this.updateDepth.incrementAndGet();
                try {
                    if (depth != 1) {
                        return;
                    }
                    TreePath path = treeSelectionEvent.getNewLeadSelectionPath();
                    if (path == null) {
                        return;
                    }
                    CommonTree node = (CommonTree)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                    CommonToken a15 = (CommonToken)STViz.this.currentScope.st.impl.tokens.get(node.getTokenStartIndex());
                    CommonToken b15 = (CommonToken)STViz.this.currentScope.st.impl.tokens.get(node.getTokenStopIndex());
                    STViz.this.highlight(STViz.this.viewFrame.template, a15.getStartIndex(), b15.getStopIndex());
                }
                finally {
                    STViz.this.updateDepth.decrementAndGet();
                }
            }
        });
        CaretListener caretListenerLabel = new CaretListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void caretUpdate(CaretEvent e15) {
                int depth = STViz.this.updateDepth.incrementAndGet();
                try {
                    if (depth != 1) {
                        return;
                    }
                    int dot = STViz.this.toEventPosition((JTextComponent)e15.getSource(), e15.getDot());
                    STViz.this.currentEvent = STViz.this.findEventAtOutputLocation(STViz.this.allEvents, dot);
                    STViz.this.currentScope = STViz.this.currentEvent == null ? STViz.this.tmodel.root.event.scope : STViz.this.currentEvent.scope;
                    List<EvalTemplateEvent> stack = Interpreter.getEvalTemplateEventStack(STViz.this.currentScope, true);
                    Object[] path = new Object[stack.size()];
                    int j15 = 0;
                    for (EvalTemplateEvent s15 : stack) {
                        path[j15++] = new JTreeSTModel.Wrapper(s15);
                    }
                    TreePath p15 = new TreePath(path);
                    STViz.this.viewFrame.tree.setSelectionPath(p15);
                    STViz.this.viewFrame.tree.scrollPathToVisible(p15);
                    STViz.this.updateCurrentST(STViz.this.viewFrame);
                }
                finally {
                    STViz.this.updateDepth.decrementAndGet();
                }
            }
        };
        this.viewFrame.output.addCaretListener(caretListenerLabel);
        if (this.errors == null || this.errors.size() == 0) {
            this.viewFrame.errorScrollPane.setVisible(false);
        } else {
            DefaultListModel<STMessage> errorListModel = new DefaultListModel<STMessage>();
            for (STMessage msg : this.errors) {
                errorListModel.addElement(msg);
            }
            this.viewFrame.errorList.setModel(errorListModel);
        }
        this.viewFrame.errorList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent e15) {
                int depth = STViz.this.updateDepth.incrementAndGet();
                try {
                    int i15;
                    if (depth != 1) {
                        return;
                    }
                    int minIndex = STViz.this.viewFrame.errorList.getMinSelectionIndex();
                    int maxIndex = STViz.this.viewFrame.errorList.getMaxSelectionIndex();
                    for (i15 = minIndex; i15 <= maxIndex && !STViz.this.viewFrame.errorList.isSelectedIndex(i15); ++i15) {
                    }
                    ListModel model = STViz.this.viewFrame.errorList.getModel();
                    STMessage msg = (STMessage)model.getElementAt(i15);
                    if (msg instanceof STRuntimeMessage) {
                        STRuntimeMessage rmsg = (STRuntimeMessage)msg;
                        Interval I11 = rmsg.self.impl.sourceMap[rmsg.ip];
                        STViz.this.currentEvent = null;
                        STViz.this.currentScope = ((STRuntimeMessage)msg).scope;
                        STViz.this.updateCurrentST(STViz.this.viewFrame);
                        if (I11 != null) {
                            STViz.this.highlight(STViz.this.viewFrame.template, I11.a, I11.b);
                        }
                    }
                }
                finally {
                    STViz.this.updateDepth.decrementAndGet();
                }
            }
        });
        Border empty = BorderFactory.createEmptyBorder();
        this.viewFrame.treeContentSplitPane.setBorder(empty);
        this.viewFrame.outputTemplateSplitPane.setBorder(empty);
        this.viewFrame.templateBytecodeTraceTabPanel.setBorder(empty);
        this.viewFrame.treeAttributesSplitPane.setBorder(empty);
        this.viewFrame.treeContentSplitPane.setOneTouchExpandable(true);
        this.viewFrame.outputTemplateSplitPane.setOneTouchExpandable(true);
        this.viewFrame.treeContentSplitPane.setDividerSize(10);
        this.viewFrame.outputTemplateSplitPane.setDividerSize(8);
        this.viewFrame.treeContentSplitPane.setContinuousLayout(true);
        this.viewFrame.treeAttributesSplitPane.setContinuousLayout(true);
        this.viewFrame.outputTemplateSplitPane.setContinuousLayout(true);
        this.viewFrame.setDefaultCloseOperation(2);
        this.viewFrame.pack();
        this.viewFrame.setSize(900, 700);
        this.setText(this.viewFrame.output, this.output);
        this.setText(this.viewFrame.template, this.currentScope.st.impl.template);
        this.setText(this.viewFrame.bytecode, this.currentScope.st.impl.disasm());
        this.setText(this.viewFrame.trace, Misc.join(this.trace.iterator(), "\n"));
        this.viewFrame.setVisible(true);
    }

    public void waitForClose() throws InterruptedException {
        final Object lock = new Object();
        Thread t15 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    while (STViz.this.viewFrame.isVisible()) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        t15.start();
        this.viewFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent arg0) {
                Object object = lock;
                synchronized (object) {
                    STViz.this.viewFrame.setVisible(false);
                    lock.notify();
                }
            }
        });
        t15.join();
    }

    private void updateCurrentST(STViewFrame m15) {
        this.updateStack(this.currentScope, m15);
        this.updateAttributes(this.currentScope, m15);
        this.setText(m15.bytecode, this.currentScope.st.impl.disasm());
        this.setText(m15.template, this.currentScope.st.impl.template);
        JTreeASTModel astModel = new JTreeASTModel(new CommonTreeAdaptor(), this.currentScope.st.impl.ast);
        this.viewFrame.ast.setModel(astModel);
        if (this.currentEvent instanceof EvalExprEvent) {
            EvalExprEvent exprEvent = (EvalExprEvent)this.currentEvent;
            this.highlight(m15.output, exprEvent.outputStartChar, exprEvent.outputStopChar);
            this.highlight(m15.template, exprEvent.exprStartChar, exprEvent.exprStopChar);
        } else {
            EvalTemplateEvent templateEvent;
            if (this.currentEvent instanceof EvalTemplateEvent) {
                templateEvent = (EvalTemplateEvent)this.currentEvent;
            } else {
                List<InterpEvent> events = this.currentScope.events;
                templateEvent = (EvalTemplateEvent)events.get(events.size() - 1);
            }
            if (templateEvent != null) {
                this.highlight(m15.output, templateEvent.outputStartChar, templateEvent.outputStopChar);
            }
            if (this.currentScope.st.isAnonSubtemplate()) {
                Interval r15 = this.currentScope.st.impl.getTemplateRange();
                this.highlight(m15.template, r15.a, r15.b);
            }
        }
    }

    protected void setText(JEditorPane component, String text) {
        ArrayList<Integer> windowsLineEndingsList = new ArrayList<Integer>();
        for (int i15 = 0; i15 < text.length() && (i15 = text.indexOf("\r\n", i15)) >= 0; i15 += 2) {
            windowsLineEndingsList.add(i15);
        }
        int[] windowsLineEndings = new int[windowsLineEndingsList.size()];
        for (int i16 = 0; i16 < windowsLineEndingsList.size(); ++i16) {
            windowsLineEndings[i16] = (Integer)windowsLineEndingsList.get(i16);
        }
        component.setText(text);
        component.getDocument().putProperty(WINDOWS_LINE_ENDINGS, windowsLineEndings);
    }

    protected int toComponentPosition(JTextComponent component, int position) {
        int[] windowsLineEndings = (int[])component.getDocument().getProperty(WINDOWS_LINE_ENDINGS);
        if (windowsLineEndings == null || windowsLineEndings.length == 0) {
            return position;
        }
        int index = Arrays.binarySearch(windowsLineEndings, position);
        if (index >= 0) {
            return position - index;
        }
        return position - (-index - 1);
    }

    protected int toEventPosition(JTextComponent component, int position) {
        int result = position;
        while (this.toComponentPosition(component, result) < position) {
            ++result;
        }
        return result;
    }

    protected final void highlight(JTextComponent comp, int i15, int j15) {
        this.highlight(comp, i15, j15, true);
    }

    protected void highlight(JTextComponent comp, int i15, int j15, boolean scroll) {
        Highlighter highlighter = comp.getHighlighter();
        highlighter.removeAllHighlights();
        try {
            i15 = this.toComponentPosition(comp, i15);
            j15 = this.toComponentPosition(comp, j15);
            highlighter.addHighlight(i15, j15 + 1, DefaultHighlighter.DefaultPainter);
            if (scroll && (comp.getCaretPosition() < i15 || comp.getCaretPosition() > j15)) {
                comp.moveCaretPosition(i15);
                comp.scrollRectToVisible(comp.modelToView(i15));
            }
        }
        catch (BadLocationException ble) {
            this.errMgr.internalError(this.tmodel.root.event.scope.st, "bad highlight location", ble);
        }
    }

    protected void updateAttributes(InstanceScope scope, STViewFrame m15) {
        m15.attributes.setModel(new JTreeScopeStackModel(scope));
        m15.attributes.setRootVisible(false);
        m15.attributes.setShowsRootHandles(true);
    }

    protected void updateStack(InstanceScope scope, STViewFrame m15) {
        List<ST> stack = Interpreter.getEnclosingInstanceStack(scope, true);
        m15.setTitle("STViz - [" + Misc.join(stack.iterator(), " ") + "]");
    }

    public InterpEvent findEventAtOutputLocation(List<InterpEvent> events, int charIndex) {
        for (InterpEvent e15 : events) {
            if (e15.scope.earlyEval || charIndex < e15.outputStartChar || charIndex > e15.outputStopChar) continue;
            return e15;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("1")) {
            STViz.test1();
        } else if (args.length > 0 && args[0].equals("2")) {
            STViz.test2();
        } else if (args.length > 0 && args[0].equals("3")) {
            STViz.test3();
        } else if (args.length > 0 && args[0].equals("4")) {
            STViz.test4();
        }
    }

    public static void test1() throws IOException {
        String templates = "method(type,name,locals,args,stats) ::= <<\npublic <type> <name>(<args:{a| int <a>}; separator=\", \">) {\n    <if(locals)>int locals[<locals>];<endif>\n    <stats;separator=\"\\n\">\n}\n>>\nassign(a,b) ::= \"<a> = <b>;\"\nreturn(x) ::= <<return <x>;>>\nparen(x) ::= \"(<x>)\"\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(tmpdir + "/" + "t.stg");
        ST st4 = group.getInstanceOf("method");
        st4.impl.dump();
        st4.add("type", "float");
        st4.add("name", "foo");
        st4.add("locals", 3);
        st4.add("args", new String[]{"x", "y", "z"});
        ST s15 = group.getInstanceOf("assign");
        ST paren = group.getInstanceOf("paren");
        paren.add("x", "x");
        s15.add("a", paren);
        s15.add("b", "y");
        ST s25 = group.getInstanceOf("assign");
        s25.add("a", "y");
        s25.add("b", "z");
        ST s35 = group.getInstanceOf("return");
        s35.add("x", "3.14159");
        st4.add("stats", s15);
        st4.add("stats", s25);
        st4.add("stats", s35);
        STViz viz = st4.inspect();
        System.out.println(st4.render());
    }

    public static void test2() throws IOException {
        String templates = "t1(q1=\"Some\\nText\") ::= <<\n<q1>\n>>\n\nt2(p1) ::= <<\n<p1>\n>>\n\nmain() ::= <<\nSTART-<t1()>-END\n\nSTART-<t2(p1=\"Some\\nText\")>-END\n>>\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(tmpdir + "/" + "t.stg");
        ST st4 = group.getInstanceOf("main");
        STViz viz = st4.inspect();
    }

    public static void test3() throws IOException {
        String templates = "main() ::= <<\nFoo: <{bar};format=\"lower\">\n>>\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(tmpdir + "/" + "t.stg");
        ST st4 = group.getInstanceOf("main");
        st4.inspect();
    }

    public static void test4() throws IOException {
        String templates = "main(t) ::= <<\nhi: <t>\n>>\nfoo(x,y={hi}) ::= \"<bar(x,y)>\"\nbar(x,y) ::= << <y> >>\nignore(m) ::= \"<m>\"\n";
        STGroupString group = new STGroupString(templates);
        ST st4 = group.getInstanceOf("main");
        ST foo = group.getInstanceOf("foo");
        st4.add("t", foo);
        ST ignore = group.getInstanceOf("ignore");
        ignore.add("m", foo);
        st4.inspect();
        st4.render();
    }

    public static void writeFile(String dir, String fileName, String content) {
        try {
            File f15 = new File(dir, fileName);
            if (!f15.getParentFile().exists()) {
                f15.getParentFile().mkdirs();
            }
            FileWriter w15 = new FileWriter(f15);
            BufferedWriter bw4 = new BufferedWriter(w15);
            bw4.write(content);
            bw4.close();
            w15.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }
}

