/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.antlr.Tool;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.Grammar;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPhrase {
    public static final boolean debug = false;
    protected static Random random;

    protected static void randomPhrase(Grammar g15, List<Integer> tokenTypes, String startRule) {
        NFAState state = g15.getRuleStartState(startRule);
        NFAState stopState = g15.getRuleStopState(startRule);
        Stack<NFAState> ruleInvocationStack = new Stack<NFAState>();
        while (state != stopState || !ruleInvocationStack.isEmpty()) {
            if (state.getNumberOfTransitions() == 0) {
                return;
            }
            if (state.isAcceptState()) {
                NFAState invokingState = (NFAState)ruleInvocationStack.pop();
                RuleClosureTransition invokingTransition = (RuleClosureTransition)invokingState.transition[0];
                state = invokingTransition.followState;
                continue;
            }
            if (state.getNumberOfTransitions() == 1) {
                Transition t05 = state.transition[0];
                if (t05 instanceof RuleClosureTransition) {
                    ruleInvocationStack.push(state);
                } else if (t05.label.isSet() || t05.label.isAtom()) {
                    tokenTypes.add(RandomPhrase.getTokenType(t05.label));
                }
                state = (NFAState)t05.target;
                continue;
            }
            int decisionNumber = state.getDecisionNumber();
            if (decisionNumber == 0) {
                System.out.println("weird: no decision number but a choice node");
                continue;
            }
            int n15 = g15.getNumberOfAltsForDecisionNFA(state);
            int randomAlt = random.nextInt(n15) + 1;
            NFAState altStartState = g15.getNFAStateForAltOfDecision(state, randomAlt);
            Transition t15 = altStartState.transition[0];
            state = (NFAState)t15.target;
        }
    }

    protected static Integer getTokenType(Label label) {
        if (label.isSet()) {
            IntervalSet typeSet = (IntervalSet)label.getSet();
            int randomIndex = random.nextInt(typeSet.size());
            return typeSet.get(randomIndex);
        }
        return Utils.integer(label.getAtom());
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: java org.antlr.tool.RandomPhrase grammarfile startrule");
            return;
        }
        String grammarFileName = args[0];
        String startRule = args[1];
        long seed = System.currentTimeMillis();
        if (args.length == 3) {
            String seedStr = args[2];
            seed = Long.parseLong(seedStr);
        }
        try {
            random = new Random(seed);
            CompositeGrammar composite = new CompositeGrammar();
            Tool tool = new Tool();
            Grammar parser = new Grammar(tool, grammarFileName, composite);
            composite.setDelegationRoot(parser);
            FileReader fr4 = new FileReader(grammarFileName);
            BufferedReader br4 = new BufferedReader(fr4);
            parser.parseAndBuildAST(br4);
            br4.close();
            parser.composite.assignTokenTypes();
            parser.composite.defineGrammarSymbols();
            parser.composite.createNFAs();
            List<? extends Collection<? extends Rule>> leftRecursiveRules = parser.checkAllRulesForLeftRecursion();
            if (leftRecursiveRules.size() > 0) {
                return;
            }
            if (parser.getRule(startRule) == null) {
                System.out.println("undefined start rule " + startRule);
                return;
            }
            String lexerGrammarText = parser.getLexerGrammar();
            Grammar lexer = new Grammar(tool);
            lexer.importTokenVocabulary(parser);
            lexer.fileName = grammarFileName;
            if (lexerGrammarText != null) {
                lexer.setGrammarContent(lexerGrammarText);
            } else {
                System.err.println("no lexer grammar found in " + grammarFileName);
            }
            lexer.buildNFA();
            leftRecursiveRules = lexer.checkAllRulesForLeftRecursion();
            if (leftRecursiveRules.size() > 0) {
                return;
            }
            ArrayList<Integer> tokenTypes = new ArrayList<Integer>(100);
            RandomPhrase.randomPhrase(parser, tokenTypes, startRule);
            System.out.println("token types=" + tokenTypes);
            for (int i15 = 0; i15 < tokenTypes.size(); ++i15) {
                Integer ttypeI = (Integer)tokenTypes.get(i15);
                int ttype = ttypeI;
                String ttypeDisplayName = parser.getTokenDisplayName(ttype);
                if (Character.isUpperCase(ttypeDisplayName.charAt(0))) {
                    ArrayList<Integer> charsInToken = new ArrayList<Integer>(10);
                    RandomPhrase.randomPhrase(lexer, charsInToken, ttypeDisplayName);
                    System.out.print(" ");
                    for (int j15 = 0; j15 < charsInToken.size(); ++j15) {
                        Integer cI2 = (Integer)charsInToken.get(j15);
                        System.out.print((char)cI2.intValue());
                    }
                    continue;
                }
                String literal = ttypeDisplayName.substring(1, ttypeDisplayName.length() - 1);
                System.out.print(" " + literal);
            }
            System.out.println();
        }
        catch (Error er4) {
            System.err.println("Error walking " + grammarFileName + " rule " + startRule + " seed " + seed);
            er4.printStackTrace(System.err);
        }
        catch (Exception e15) {
            System.err.println("Exception walking " + grammarFileName + " rule " + startRule + " seed " + seed);
            e15.printStackTrace(System.err);
        }
    }
}

