/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings.utils;

import jadx.api.ICodeInfo;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.utils.CodeUtils;
import jadx.core.dex.nodes.MethodNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VariablesUtils.class);

    public static List<VarInfo> collect(MethodNode mth) {
        ICodeInfo codeInfo = mth.getTopParentClass().getCode();
        int mthDefPos = mth.getDefPosition();
        int mthLineEndPos = CodeUtils.getLineEndForPos(codeInfo.getCodeStr(), mthDefPos);
        CodeVisitor codeVisitor = new CodeVisitor(mth);
        codeInfo.getCodeMetadata().searchDown(mthLineEndPos, codeVisitor::process);
        return codeVisitor.getVars();
    }

    private static class CodeVisitor {
        private final MethodNode mth;
        private final List<VarInfo> vars = new ArrayList<VarInfo>();
        private int lastOffset = -1;

        public CodeVisitor(MethodNode mth) {
            this.mth = mth;
        }

        @Nullable
        public Boolean process(Integer pos, ICodeAnnotation ann) {
            ICodeNodeRef declRef;
            if (ann instanceof InsnCodeOffset) {
                this.lastOffset = ((InsnCodeOffset)ann).getOffset();
            }
            if (ann instanceof NodeDeclareRef && (declRef = ((NodeDeclareRef)ann).getNode()) instanceof VarNode) {
                VarNode varNode = (VarNode)declRef;
                if (!varNode.getMth().equals(this.mth)) {
                    if (!this.vars.isEmpty()) {
                        this.vars.get(this.vars.size() - 1).setEndOpIdx(declRef.getDefPosition() - 1);
                    }
                    return Boolean.TRUE;
                }
                if (this.lastOffset != -1) {
                    if (!this.vars.isEmpty()) {
                        this.vars.get(this.vars.size() - 1).setEndOpIdx(this.lastOffset - 1);
                    }
                    this.vars.add(new VarInfo(varNode, this.lastOffset));
                } else {
                    LOG.warn("Local variable not present in bytecode, skipping: {}#{}", (Object)this.mth.getMethodInfo().getRawFullId(), (Object)varNode.getName());
                }
                this.lastOffset = -1;
            }
            return null;
        }

        public List<VarInfo> getVars() {
            return this.vars;
        }
    }

    public static class VarInfo {
        private final VarNode var;
        private final int startOpIdx;
        private int endOpIdx;

        public VarInfo(VarNode var, int startOpIdx) {
            this.var = var;
            this.startOpIdx = startOpIdx;
            this.endOpIdx = startOpIdx;
        }

        public VarNode getVar() {
            return this.var;
        }

        public int getStartOpIdx() {
            return this.startOpIdx;
        }

        public int getEndOpIdx() {
            return this.endOpIdx;
        }

        public void setEndOpIdx(int endOpIdx) {
            this.endOpIdx = endOpIdx;
        }
    }
}

