/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.api.plugins.input.data.IMethodRef;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.data.JavaMethodProto;
import jadx.plugins.input.java.utils.DescriptorParser;

public class JavaMethodRef
extends JavaMethodProto
implements IMethodRef {
    private int uniqId;
    private String parentClassType;
    private String name;
    private String descr;

    @Override
    public int getUniqId() {
        return this.uniqId;
    }

    public void initUniqId(JavaClassReader clsReader, int id5, boolean fromConstPool) {
        int readerId = clsReader.getId();
        if (readerId > 65535 || id5 > Short.MAX_VALUE) {
            this.uniqId = 0;
        } else {
            int source = fromConstPool ? 0 : 32768;
            this.uniqId = (readerId & 0xFFFF) << 16 | source | id5 & Short.MAX_VALUE;
        }
    }

    @Override
    public String getParentClassType() {
        return this.parentClassType;
    }

    public void setParentClassType(String parentClassType) {
        this.parentClassType = parentClassType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void reset() {
        this.setReturnType(null);
        this.setArgTypes(null);
    }

    @Override
    public void load() {
        if (this.getReturnType() == null) {
            DescriptorParser.fillMethodProto(this.descr, this);
        }
    }

    @Override
    public String toString() {
        return this.parentClassType + "->" + this.name + this.descr;
    }
}

