/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.ui.panel.LogcatPanel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogcatController {
    private static final Logger LOG = LoggerFactory.getLogger(LogcatController.class);
    private final ADBDevice adbDevice;
    private final LogcatPanel logcatPanel;
    private Timer timer;
    private final String timezone;
    private LogcatInfo recent = null;
    private List<LogcatInfo> events = new ArrayList<LogcatInfo>();
    private LogcatFilter filter = new LogcatFilter(null, null);
    private String status = "null";

    public LogcatController(LogcatPanel logcatPanel, ADBDevice adbDevice) throws IOException {
        this.adbDevice = adbDevice;
        this.logcatPanel = logcatPanel;
        this.timezone = adbDevice.getTimezone();
        this.startLogcat();
    }

    public void startLogcat() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                LogcatController.this.getLog();
            }
        }, 0L, 1000L);
        this.status = "running";
    }

    public void stopLogcat() {
        this.timer.cancel();
        this.status = "stopped";
    }

    public String getStatus() {
        return this.status;
    }

    public void clearLogcat() {
        try {
            this.adbDevice.clearLogcat();
            this.clearEvents();
        }
        catch (IOException e15) {
            LOG.error("Failed to clear Logcat", e15);
        }
    }

    private void getLog() {
        if (!this.logcatPanel.isReady()) {
            return;
        }
        try {
            byte[] buf = this.recent == null ? this.adbDevice.getBinaryLogcat() : this.adbDevice.getBinaryLogcat(this.recent.getAfterTimestamp());
            if (buf == null) {
                return;
            }
            ByteBuffer in4 = ByteBuffer.wrap(buf);
            in4.order(ByteOrder.LITTLE_ENDIAN);
            while (in4.remaining() > 20) {
                short eHdrLen;
                LogcatInfo eInfo = null;
                short eLen = in4.getShort();
                if (eLen + (eHdrLen = in4.getShort()) > in4.remaining()) {
                    return;
                }
                switch (eHdrLen) {
                    case 20: {
                        eInfo = new LogcatInfo(eLen, eHdrLen, in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.get());
                        byte[] msgBuf = new byte[eLen];
                        in4.get(msgBuf, 0, eLen - 1);
                        eInfo.setMsg(msgBuf);
                        break;
                    }
                    case 24: {
                        eInfo = new LogcatInfo(eLen, eHdrLen, in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.get());
                        byte[] msgBuf = new byte[eLen];
                        in4.get(msgBuf, 0, eLen - 1);
                        eInfo.setMsg(msgBuf);
                        break;
                    }
                    case 28: {
                        eInfo = new LogcatInfo(eLen, eHdrLen, in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.getInt(), in4.get());
                        byte[] msgBuf = new byte[eLen];
                        in4.get(msgBuf, 0, eLen - 1);
                        eInfo.setMsg(msgBuf);
                        break;
                    }
                }
                if (eInfo == null) {
                    return;
                }
                if (this.recent == null) {
                    this.recent = eInfo;
                } else if (this.recent.getInstant().isBefore(eInfo.getInstant())) {
                    this.recent = eInfo;
                }
                if (this.filter.doFilter(eInfo)) {
                    this.logcatPanel.log(eInfo);
                }
                this.events.add(eInfo);
            }
        }
        catch (Exception e15) {
            LOG.error("Failed to get logcat message", e15);
        }
    }

    public boolean reload() {
        this.stopLogcat();
        boolean ok4 = this.logcatPanel.clearLogcatArea();
        if (ok4) {
            this.events.forEach(eInfo -> {
                if (this.filter.doFilter((LogcatInfo)eInfo)) {
                    this.logcatPanel.log((LogcatInfo)eInfo);
                }
            });
            this.startLogcat();
        }
        return true;
    }

    public void clearEvents() {
        this.recent = null;
        this.events = new ArrayList<LogcatInfo>();
    }

    public void exit() {
        this.stopLogcat();
        this.filter = new LogcatFilter(null, null);
        this.recent = null;
    }

    public LogcatFilter getFilter() {
        return this.filter;
    }

    public class LogcatInfo {
        private String msg;
        private final byte msgType;
        private final int nsec;
        private final int pid;
        private final int sec;
        private final int tid;
        private final short hdrSize;
        private final short len;
        private final short version;
        private int lid;
        private int uid;

        public LogcatInfo(short len, short hdrSize, int pid, int tid, int sec, int nsec, byte msgType) {
            this.hdrSize = hdrSize;
            this.len = len;
            this.msgType = msgType;
            this.nsec = nsec;
            this.pid = pid;
            this.sec = sec;
            this.tid = tid;
            this.version = 1;
        }

        public LogcatInfo(short len, short hdrSize, int pid, int tid, int sec, int nsec, int lid, byte msgType) {
            this.hdrSize = hdrSize;
            this.len = len;
            this.lid = lid;
            this.msgType = msgType;
            this.nsec = nsec;
            this.pid = pid;
            this.sec = sec;
            this.tid = tid;
            this.version = (short)3;
        }

        public LogcatInfo(short len, short hdrSize, int pid, int tid, int sec, int nsec, int lid, int uid, byte msgType) {
            this.hdrSize = hdrSize;
            this.len = len;
            this.lid = lid;
            this.msgType = msgType;
            this.nsec = nsec;
            this.pid = pid;
            this.sec = sec;
            this.tid = tid;
            this.uid = uid;
            this.version = (short)4;
        }

        public void setMsg(byte[] msg) {
            this.msg = new String(msg);
        }

        public short getVersion() {
            return this.version;
        }

        public short getLen() {
            return this.len;
        }

        public short getHeaderLen() {
            return this.hdrSize;
        }

        public int getPid() {
            return this.pid;
        }

        public int getTid() {
            return this.tid;
        }

        public int getSec() {
            return this.sec;
        }

        public int getNSec() {
            return this.nsec;
        }

        public int getLid() {
            return this.lid;
        }

        public int getUid() {
            return this.uid;
        }

        public Instant getInstant() {
            return Instant.ofEpochSecond(this.getSec(), this.getNSec());
        }

        public String getTimestamp() {
            DateTimeFormatter dtFormat = DateTimeFormatter.ofPattern("MM-dd HH:mm:ss.SSS").withZone(ZoneId.of(LogcatController.this.timezone));
            return dtFormat.format(this.getInstant());
        }

        public String getAfterTimestamp() {
            DateTimeFormatter dtFormat = DateTimeFormatter.ofPattern("MM-dd HH:mm:ss.SSS").withZone(ZoneId.of(LogcatController.this.timezone));
            return dtFormat.format(this.getInstant().plusMillis(1L));
        }

        public byte getMsgType() {
            return this.msgType;
        }

        public String getMsgTypeString() {
            switch (this.getMsgType()) {
                case 0: {
                    return "Unknown";
                }
                case 1: {
                    return "Default";
                }
                case 2: {
                    return "Verbose";
                }
                case 3: {
                    return "Debug";
                }
                case 4: {
                    return "Info";
                }
                case 5: {
                    return "Warn";
                }
                case 6: {
                    return "Error";
                }
                case 7: {
                    return "Fatal";
                }
                case 8: {
                    return "Silent";
                }
            }
            return "Unknown";
        }

        public String getMsg() {
            return this.msg;
        }
    }

    public class LogcatFilter {
        private final List<Integer> pid;
        private List<Byte> msgType = new ArrayList<Byte>(){
            {
                this.add((byte)1);
                this.add((byte)2);
                this.add((byte)3);
                this.add((byte)4);
                this.add((byte)5);
                this.add((byte)6);
                this.add((byte)7);
                this.add((byte)8);
            }
        };

        public LogcatFilter(ArrayList<Integer> pid, ArrayList<Byte> msgType) {
            this.pid = pid != null ? pid : new ArrayList<Integer>();
            if (msgType != null) {
                this.msgType = msgType;
            }
        }

        public void addPid(int pid) {
            if (!this.pid.contains(pid)) {
                this.pid.add(pid);
            }
        }

        public void removePid(int pid) {
            int pidPos = this.pid.indexOf(pid);
            if (pidPos >= 0) {
                this.pid.remove(pidPos);
            }
        }

        public void togglePid(int pid, boolean state) {
            if (state) {
                this.addPid(pid);
            } else {
                this.removePid(pid);
            }
        }

        public void addMsgType(byte msgType) {
            if (!this.msgType.contains(msgType)) {
                this.msgType.add(msgType);
            }
        }

        public void removeMsgType(byte msgType) {
            int typePos = this.msgType.indexOf(msgType);
            if (typePos >= 0) {
                this.msgType.remove(typePos);
            }
        }

        public void toggleMsgType(byte msgType, boolean state) {
            if (state) {
                this.addMsgType(msgType);
            } else {
                this.removeMsgType(msgType);
            }
        }

        public boolean doFilter(LogcatInfo inInfo) {
            if (this.pid.contains(inInfo.getPid())) {
                return this.msgType.contains(inInfo.getMsgType());
            }
            return false;
        }

        public List<LogcatInfo> getFilteredList(List<LogcatInfo> inInfoList) {
            ArrayList<LogcatInfo> outInfoList = new ArrayList<LogcatInfo>();
            inInfoList.forEach(inInfo -> {
                if (this.doFilter((LogcatInfo)inInfo)) {
                    outInfoList.add((LogcatInfo)inInfo);
                }
            });
            return outInfoList;
        }
    }
}

