/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.usage;

import jadx.api.usage.IUsageInfoData;
import jadx.api.usage.IUsageInfoVisitor;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.cache.usage.ClsUsageData;
import jadx.gui.cache.usage.FldUsageData;
import jadx.gui.cache.usage.MthRef;
import jadx.gui.cache.usage.MthUsageData;
import jadx.gui.cache.usage.RawUsageData;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UsageData
implements IUsageInfoData {
    private static final Logger LOG = LoggerFactory.getLogger(UsageData.class);
    private final RootNode root;
    private final RawUsageData rawUsageData;

    public UsageData(RootNode root, RawUsageData rawUsageData) {
        this.root = root;
        this.rawUsageData = rawUsageData;
    }

    @Override
    public void apply() {
        Map<String, ClsUsageData> clsMap = this.rawUsageData.getClsMap();
        for (ClassNode cls : this.root.getClasses()) {
            String clsRawName = cls.getRawName();
            ClsUsageData clsUsageData = clsMap.get(clsRawName);
            if (clsUsageData == null) continue;
            this.applyForClass(clsUsageData, cls);
        }
    }

    @Override
    public void applyForClass(ClassNode cls) {
        String clsRawName = cls.getRawName();
        ClsUsageData clsUsageData = this.rawUsageData.getClsMap().get(clsRawName);
        if (clsUsageData == null) {
            LOG.debug("No usage data for class: {}", (Object)clsRawName);
            return;
        }
        this.applyForClass(clsUsageData, cls);
    }

    private void applyForClass(ClsUsageData clsUsageData, ClassNode cls) {
        cls.setDependencies(this.resolveClsList(clsUsageData.getClsDeps()));
        cls.setUseIn(this.resolveClsList(clsUsageData.getClsUsage()));
        cls.setUseInMth(this.resolveMthList(clsUsageData.getClsUseInMth()));
        Map<String, MthUsageData> mthUsage = clsUsageData.getMthUsage();
        for (MethodNode mth : cls.getMethods()) {
            MthUsageData mthUsageData = mthUsage.get(mth.getMethodInfo().getShortId());
            if (mthUsageData == null) continue;
            mth.setUseIn(this.resolveMthList(mthUsageData.getUsage()));
        }
        Map<String, FldUsageData> fldUsage = clsUsageData.getFldUsage();
        for (FieldNode fld : cls.getFields()) {
            FldUsageData fldUsageData = fldUsage.get(fld.getFieldInfo().getShortId());
            if (fldUsageData == null) continue;
            fld.setUseIn(this.resolveMthList(fldUsageData.getUsage()));
        }
    }

    @Override
    public void visitUsageData(IUsageInfoVisitor visitor2) {
        throw new JadxRuntimeException("Not implemented");
    }

    private List<ClassNode> resolveClsList(List<String> clsList) {
        return Utils.collectionMap(clsList, this.root::resolveRawClass);
    }

    private List<MethodNode> resolveMthList(List<MthRef> mthRefList) {
        return Utils.collectionMap(mthRefList, m15 -> this.root.resolveDirectMethod(m15.getCls(), m15.getShortId()));
    }
}

