/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.AnonymousClassAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.MethodUtils;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.AttachMethodDetails;
import jadx.core.dex.visitors.ConstInlineVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBound;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeBoundCheckCastAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundConst;
import jadx.core.dex.visitors.typeinference.TypeBoundFieldGetAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundInvokeAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundInvokeUse;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Type Inference", desc="Calculate best types for SSA variables", runAfter={SSATransform.class, ConstInlineVisitor.class, AttachMethodDetails.class})
public final class TypeInferenceVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeInferenceVisitor.class);
    private RootNode root;
    private TypeUpdate typeUpdate;

    @Override
    public void init(RootNode root) {
        this.root = root;
        this.typeUpdate = root.getTypeUpdate();
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        try {
            this.assignImmutableTypes(mth);
            this.initTypeBounds(mth);
            this.runTypePropagation(mth);
        }
        catch (BootstrapMethodError | StackOverflowError e15) {
            mth.addError("Type inference failed with stack overflow", new JadxOverflowException(e15.getMessage()));
        }
        catch (Exception e16) {
            mth.addError("Type inference failed", e16);
        }
    }

    void initTypeBounds(MethodNode mth) {
        List<SSAVar> ssaVars = mth.getSVars();
        ssaVars.forEach(this::attachBounds);
        ssaVars.forEach(this::mergePhiBounds);
    }

    boolean runTypePropagation(MethodNode mth) {
        List<SSAVar> ssaVars = mth.getSVars();
        ssaVars.forEach(var -> this.setImmutableType(mth, (SSAVar)var));
        ssaVars.forEach(var -> this.setBestType(mth, (SSAVar)var));
        return true;
    }

    private void setImmutableType(MethodNode mth, SSAVar ssaVar) {
        try {
            ArgType immutableType = ssaVar.getImmutableType();
            if (immutableType != null) {
                TypeUpdateResult typeUpdateResult = this.typeUpdate.applyWithWiderIgnSame(mth, ssaVar, immutableType);
            }
        }
        catch (JadxOverflowException e15) {
            throw e15;
        }
        catch (Exception e16) {
            mth.addWarnComment("Failed to set immutable type for var: " + String.valueOf(ssaVar), e16);
        }
    }

    private void setBestType(MethodNode mth, SSAVar ssaVar) {
        try {
            this.calculateFromBounds(mth, ssaVar);
        }
        catch (JadxOverflowException e15) {
            throw e15;
        }
        catch (Exception e16) {
            mth.addWarnComment("Failed to calculate best type for var: " + String.valueOf(ssaVar), e16);
        }
    }

    private void calculateFromBounds(MethodNode mth, SSAVar ssaVar) {
        TypeInfo typeInfo = ssaVar.getTypeInfo();
        Set<ITypeBound> bounds = typeInfo.getBounds();
        Optional<ArgType> bestTypeOpt = this.selectBestTypeFromBounds(bounds);
        if (bestTypeOpt.isEmpty()) {
            return;
        }
        ArgType candidateType = bestTypeOpt.get();
        TypeUpdateResult result = this.typeUpdate.apply(mth, ssaVar, candidateType);
    }

    private Optional<ArgType> selectBestTypeFromBounds(Set<ITypeBound> bounds) {
        return bounds.stream().map(ITypeBound::getType).filter(Objects::nonNull).max(this.typeUpdate.getTypeCompare().getComparator());
    }

    private void attachBounds(SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        typeInfo.getBounds().clear();
        RegisterArg assign = var.getAssign();
        this.addAssignBound(typeInfo, assign);
        for (RegisterArg regArg : var.getUseList()) {
            this.addBound(typeInfo, this.makeUseBound(regArg));
        }
    }

    private void mergePhiBounds(SSAVar ssaVar) {
        for (PhiInsn usedInPhi : ssaVar.getUsedInPhi()) {
            Set<ITypeBound> bounds = ssaVar.getTypeInfo().getBounds();
            bounds.addAll(usedInPhi.getResult().getSVar().getTypeInfo().getBounds());
            for (InsnArg arg : usedInPhi.getArguments()) {
                bounds.addAll(((RegisterArg)arg).getSVar().getTypeInfo().getBounds());
            }
        }
    }

    private void addBound(TypeInfo typeInfo, ITypeBound bound) {
        if (bound == null) {
            return;
        }
        if (bound instanceof ITypeBoundDynamic || bound.getType() != ArgType.UNKNOWN) {
            typeInfo.getBounds().add(bound);
        }
    }

    private void addAssignBound(TypeInfo typeInfo, RegisterArg assign) {
        ArgType immutableType = assign.getImmutableType();
        if (immutableType != null) {
            this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, immutableType));
            return;
        }
        InsnNode insn = assign.getParentInsn();
        if (insn == null || insn.getResult() == null) {
            this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, assign.getInitType()));
            return;
        }
        switch (insn.getType()) {
            case NEW_INSTANCE: {
                ArgType clsType = (ArgType)((IndexInsnNode)insn).getIndex();
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, clsType));
                break;
            }
            case CONSTRUCTOR: {
                ArgType ctrClsType = this.replaceAnonymousType((ConstructorInsn)insn);
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, ctrClsType));
                break;
            }
            case CONST: {
                LiteralArg constLit = (LiteralArg)insn.getArg(0);
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, constLit.getType()));
                break;
            }
            case MOVE_EXCEPTION: {
                ExcHandlerAttr excHandlerAttr = insn.get(AType.EXC_HANDLER);
                if (excHandlerAttr != null) {
                    for (ClassInfo catchType : excHandlerAttr.getHandler().getCatchTypes()) {
                        this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, catchType.getType()));
                    }
                    break;
                }
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, insn.getResult().getInitType()));
                break;
            }
            case INVOKE: {
                this.addBound(typeInfo, this.makeAssignInvokeBound((InvokeNode)insn));
                break;
            }
            case IGET: {
                this.addBound(typeInfo, this.makeAssignFieldGetBound((IndexInsnNode)insn));
                break;
            }
            case CHECK_CAST: {
                if (insn.contains(AFlag.SOFT_CAST)) break;
                this.addBound(typeInfo, new TypeBoundCheckCastAssign(this.root, (IndexInsnNode)insn));
                break;
            }
            default: {
                ArgType type = insn.getResult().getInitType();
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, type));
            }
        }
    }

    private ArgType replaceAnonymousType(ConstructorInsn ctr) {
        AnonymousClassAttr baseTypeAttr;
        ClassNode ctrCls;
        if (ctr.isNewInstance() && (ctrCls = this.root.resolveClass(ctr.getClassType())) != null && ctrCls.contains(AFlag.DONT_GENERATE) && (baseTypeAttr = ctrCls.get(AType.ANONYMOUS_CLASS)) != null && baseTypeAttr.getInlineType() == AnonymousClassAttr.InlineType.CONSTRUCTOR) {
            return baseTypeAttr.getBaseType();
        }
        return ctr.getClassType().getType();
    }

    private ITypeBound makeAssignFieldGetBound(IndexInsnNode insn) {
        ArgType initType = insn.getResult().getInitType();
        if (initType.containsTypeVariable()) {
            return new TypeBoundFieldGetAssign(this.root, insn, initType);
        }
        return new TypeBoundConst(BoundEnum.ASSIGN, initType);
    }

    private ITypeBound makeAssignInvokeBound(InvokeNode invokeNode) {
        ArgType boundType = invokeNode.getCallMth().getReturnType();
        ArgType genericReturnType = this.root.getMethodUtils().getMethodGenericReturnType(invokeNode);
        if (genericReturnType != null) {
            if (genericReturnType.containsTypeVariable()) {
                InvokeType invokeType = invokeNode.getInvokeType();
                if (invokeNode.getArgsCount() != 0 && invokeType != InvokeType.STATIC && invokeType != InvokeType.SUPER) {
                    return new TypeBoundInvokeAssign(this.root, invokeNode, genericReturnType);
                }
            } else {
                boundType = genericReturnType;
            }
        }
        return new TypeBoundConst(BoundEnum.ASSIGN, boundType);
    }

    @Nullable
    private ITypeBound makeUseBound(RegisterArg regArg) {
        ITypeBound invokeUseBound;
        InsnNode insn = regArg.getParentInsn();
        if (insn == null) {
            return null;
        }
        if (insn instanceof BaseInvokeNode && (invokeUseBound = this.makeInvokeUseBound(regArg, (BaseInvokeNode)insn)) != null) {
            return invokeUseBound;
        }
        if (insn.getType() == InsnType.CHECK_CAST && insn.contains(AFlag.SOFT_CAST)) {
            return null;
        }
        return new TypeBoundConst(BoundEnum.USE, regArg.getInitType(), regArg);
    }

    private ITypeBound makeInvokeUseBound(RegisterArg regArg, BaseInvokeNode invoke) {
        InsnArg instanceArg = invoke.getInstanceArg();
        if (instanceArg == null) {
            return null;
        }
        MethodUtils methodUtils = this.root.getMethodUtils();
        IMethodDetails methodDetails = methodUtils.getMethodDetails(invoke);
        if (methodDetails == null) {
            return null;
        }
        if (instanceArg != regArg) {
            int argIndex = invoke.getArgIndex(regArg) - invoke.getFirstArgOffset();
            ArgType argType = methodDetails.getArgTypes().get(argIndex);
            if (!argType.containsTypeVariable()) {
                return null;
            }
            return new TypeBoundInvokeUse(this.root, invoke, regArg, argType);
        }
        if (methodDetails instanceof MethodNode) {
            MethodNode callMth = (MethodNode)methodDetails;
            ClassInfo declCls = methodUtils.getMethodOriginDeclClass(callMth);
            return new TypeBoundConst(BoundEnum.USE, declCls.getType(), regArg);
        }
        return null;
    }

    private void assignImmutableTypes(MethodNode mth) {
        for (SSAVar ssaVar : mth.getSVars()) {
            ArgType immutableType = TypeInferenceVisitor.getSsaImmutableType(ssaVar);
            if (immutableType == null) continue;
            ssaVar.markAsImmutable(immutableType);
        }
    }

    @Nullable
    private static ArgType getSsaImmutableType(SSAVar ssaVar) {
        if (ssaVar.getAssign().contains(AFlag.IMMUTABLE_TYPE)) {
            return ssaVar.getAssign().getInitType();
        }
        for (RegisterArg reg : ssaVar.getUseList()) {
            if (!reg.contains(AFlag.IMMUTABLE_TYPE)) continue;
            return reg.getInitType();
        }
        return null;
    }

    @Override
    public String getName() {
        return "TypeInferenceVisitor";
    }

    private static /* synthetic */ void lambda$initTypeBounds$0(SSAVar ssaVar) {
        LOG.debug("Type bounds for {}: {}", (Object)ssaVar.toShortString(), (Object)ssaVar.getTypeInfo().getBounds());
    }
}

