/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.blocks.DominatorTree;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import java.util.ArrayList;
import java.util.BitSet;

public class PostDominatorTree {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compute(MethodNode mth) {
        if (!mth.contains(AFlag.COMPUTE_POST_DOM)) {
            return;
        }
        try {
            BlockNode block;
            int i15;
            int mthBlocksCount = mth.getBasicBlocks().size();
            ArrayList<BlockNode> sorted2 = new ArrayList<BlockNode>(mthBlocksCount);
            BlockUtils.visitReverseDFS(mth, sorted2::add);
            int blocksCount = sorted2.size();
            int[] posMapping = new int[mthBlocksCount];
            for (int i16 = 0; i16 < blocksCount; ++i16) {
                posMapping[i16] = ((BlockNode)sorted2.get(i16)).getPos();
            }
            BlockNode.updateBlockPositions(sorted2);
            BlockNode[] postDoms = DominatorTree.build(sorted2, BlockNode::getSuccessors);
            BlockNode firstBlock = (BlockNode)sorted2.get(0);
            firstBlock.setPostDoms(EmptyBitSet.EMPTY);
            firstBlock.setIPostDom(null);
            for (i15 = 1; i15 < blocksCount; ++i15) {
                block = (BlockNode)sorted2.get(i15);
                BlockNode iPostDom = postDoms[i15];
                block.setIPostDom(iPostDom);
                BitSet postDomBS = DominatorTree.collectDoms(postDoms, iPostDom);
                block.setPostDoms(postDomBS);
            }
            for (i15 = 1; i15 < blocksCount; ++i15) {
                block = (BlockNode)sorted2.get(i15);
                BitSet bs4 = new BitSet(blocksCount);
                block.getPostDoms().stream().forEach(n15 -> bs4.set(posMapping[n15]));
                bs4.clear(posMapping[i15]);
                block.setPostDoms(bs4);
            }
            int blocksDelta = mthBlocksCount - blocksCount;
            if (blocksDelta != 0) {
                int insnsCount = 0;
                for (BlockNode block2 : mth.getBasicBlocks()) {
                    if (block2.getPostDoms() != null) continue;
                    block2.setPostDoms(EmptyBitSet.EMPTY);
                    block2.setIPostDom(null);
                    insnsCount += block2.getInstructions().size();
                }
                mth.addInfoComment("Infinite loop detected, blocks: " + blocksDelta + ", insns: " + insnsCount);
            }
        }
        catch (Exception | StackOverflowError e15) {
            mth.addWarnComment("Failed to build post-dominance tree", e15);
        }
        finally {
            mth.updateBlockPositions();
        }
    }
}

