/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.variables.ProcessVariables;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="ApplyVariableNames", desc="Try to guess variable name from usage", runAfter={ProcessVariables.class})
public class ApplyVariableNames
extends AbstractVisitor {
    private static final Map<String, String> OBJ_ALIAS = Utils.newConstStringMap("java.lang.String", "str", "java.lang.Class", "cls", "java.lang.Throwable", "th", "java.lang.Object", "obj", "java.util.Iterator", "it", "java.util.HashMap", "map", "java.lang.Boolean", "bool", "java.lang.Short", "sh", "java.lang.Integer", "num", "java.lang.Character", "ch", "java.lang.Byte", "b", "java.lang.Float", "f", "java.lang.Long", "l", "java.lang.Double", "d", "java.lang.StringBuilder", "sb", "java.lang.Exception", "exc");
    private static final Set<String> GOOD_VAR_NAMES = Set.of("size", "length", "list", "map", "next");
    private static final List<String> INVOKE_PREFIXES = List.of("get", "set", "to", "parse", "read", "format");
    private RootNode root;

    @Override
    public void init(RootNode root) throws JadxException {
        this.root = root;
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        for (SSAVar ssaVar : mth.getSVars()) {
            CodeVar codeVar = ssaVar.getCodeVar();
            String newName = this.guessName(codeVar);
            if (newName == null) continue;
            codeVar.setName(newName);
        }
    }

    @Nullable
    private String guessName(CodeVar var) {
        if (var.isThis()) {
            return "this";
        }
        if (!var.isDeclared()) {
            return null;
        }
        if (NameMapper.isValidAndPrintable(var.getName())) {
            return null;
        }
        List<SSAVar> ssaVars = var.getSsaVars();
        if (Utils.notEmpty(ssaVars)) {
            boolean mthArg = ssaVars.stream().anyMatch(ssaVar -> ssaVar.getAssign().contains(AFlag.METHOD_ARGUMENT));
            if (mthArg) {
                return this.makeNameForType(var.getType());
            }
            for (SSAVar ssaVar2 : ssaVars) {
                String name = this.makeNameForSSAVar(ssaVar2);
                if (name == null) continue;
                return name;
            }
        }
        return this.makeNameForType(var.getType());
    }

    @Nullable
    private String makeNameForSSAVar(SSAVar ssaVar) {
        String name;
        String ssaVarName = ssaVar.getName();
        if (ssaVarName != null) {
            return ssaVarName;
        }
        InsnNode assignInsn = ssaVar.getAssignInsn();
        if (assignInsn != null && NameMapper.isValidAndPrintable(name = this.makeNameFromInsn(ssaVar, assignInsn))) {
            return name;
        }
        return null;
    }

    private String makeNameFromInsn(SSAVar ssaVar, InsnNode insn) {
        switch (insn.getType()) {
            case INVOKE: {
                return this.makeNameFromInvoke(ssaVar, (InvokeNode)insn);
            }
            case CONSTRUCTOR: {
                ConstructorInsn co4 = (ConstructorInsn)insn;
                MethodNode callMth = this.root.getMethodUtils().resolveMethod(co4);
                if (callMth != null && callMth.contains(AFlag.ANONYMOUS_CONSTRUCTOR)) {
                    return null;
                }
                return this.makeNameForClass(co4.getClassType());
            }
            case ARRAY_LENGTH: {
                return "length";
            }
            case ARITH: 
            case TERNARY: 
            case CAST: {
                for (InsnArg arg : insn.getArguments()) {
                    InsnNode wrapInsn;
                    String wName;
                    if (!arg.isInsnWrap() || (wName = this.makeNameFromInsn(ssaVar, wrapInsn = ((InsnWrapArg)arg).getWrapInsn())) == null) continue;
                    return wName;
                }
                break;
            }
        }
        return null;
    }

    private String makeNameForType(ArgType type) {
        if (type.isPrimitive()) {
            return type.getPrimitiveType().getShortName().toLowerCase();
        }
        if (type.isArray()) {
            return this.makeNameForType(type.getArrayRootElement()) + "Arr";
        }
        return this.makeNameForObject(type);
    }

    private String makeNameForObject(ArgType type) {
        if (type.isGenericType()) {
            return StringUtils.escape(type.getObject().toLowerCase());
        }
        if (type.isObject()) {
            String alias = ApplyVariableNames.getAliasForObject(type.getObject());
            if (alias != null) {
                return alias;
            }
            return this.makeNameForCheckedClass(ClassInfo.fromType(this.root, type));
        }
        return StringUtils.escape(type.toString());
    }

    private String makeNameForCheckedClass(ClassInfo classInfo) {
        String shortName = classInfo.getAliasShortName();
        String vName = ApplyVariableNames.fromName(shortName);
        if (vName != null) {
            return vName;
        }
        String lower = StringUtils.escape(shortName.toLowerCase());
        if (shortName.equals(lower)) {
            return lower + "Var";
        }
        return lower;
    }

    private String makeNameForClass(ClassInfo classInfo) {
        String alias = ApplyVariableNames.getAliasForObject(classInfo.getFullName());
        if (alias != null) {
            return alias;
        }
        return this.makeNameForCheckedClass(classInfo);
    }

    private static String fromName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.toUpperCase().equals(name)) {
            return name.toLowerCase();
        }
        String v15 = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (!v15.equals(name)) {
            return v15;
        }
        if (name.length() < 3) {
            return name + "Var";
        }
        return null;
    }

    private static String getAliasForObject(String name) {
        return OBJ_ALIAS.get(name);
    }

    private String makeNameFromInvoke(SSAVar ssaVar, InvokeNode inv) {
        String typeName;
        MethodInfo callMth = inv.getCallMth();
        String name = callMth.getAlias();
        ClassInfo declClass = callMth.getDeclClass();
        if ("getInstance".equals(name)) {
            return this.makeNameForClass(declClass);
        }
        String shortName = this.cutPrefix(name);
        if (shortName != null) {
            return ApplyVariableNames.fromName(shortName);
        }
        if ("iterator".equals(name)) {
            return "it";
        }
        if ("toString".equals(name)) {
            return this.makeNameForClass(declClass);
        }
        if ("forName".equals(name) && declClass.getType().equals(ArgType.CLASS)) {
            return OBJ_ALIAS.get("java.lang.Class");
        }
        if (!GOOD_VAR_NAMES.contains(name) && !(typeName = this.makeNameForType(ssaVar.getCodeVar().getType())).equalsIgnoreCase(name)) {
            return typeName + StringUtils.capitalizeFirstChar(name);
        }
        return name;
    }

    @Nullable
    private String cutPrefix(String name) {
        for (String prefix : INVOKE_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return name.substring(prefix.length());
        }
        return null;
    }

    @Override
    public String getName() {
        return "ApplyVariableNames";
    }
}

