/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.Utils;
import java.util.List;

public interface IMethodDetails
extends IJadxAttribute {
    public MethodInfo getMethodInfo();

    public ArgType getReturnType();

    public List<ArgType> getArgTypes();

    public List<ArgType> getTypeParameters();

    public List<ArgType> getThrows();

    public boolean isVarArg();

    public int getRawAccessFlags();

    default public AType<IMethodDetails> getAttrType() {
        return AType.METHOD_DETAILS;
    }

    @Override
    default public String toAttrString() {
        List<ArgType> throwsList;
        StringBuilder sb5 = new StringBuilder();
        sb5.append("MD:");
        if (Utils.notEmpty(this.getTypeParameters())) {
            sb5.append('<');
            sb5.append(Utils.listToString(this.getTypeParameters()));
            sb5.append(">:");
        }
        sb5.append('(');
        sb5.append(Utils.listToString(this.getArgTypes()));
        sb5.append("):");
        sb5.append(this.getReturnType());
        if (this.isVarArg()) {
            sb5.append(" VARARG");
        }
        if (Utils.notEmpty(throwsList = this.getThrows())) {
            sb5.append(" throws ").append(Utils.listToString(throwsList));
        }
        return sb5.toString();
    }
}

