/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrList;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.InsnNode;
import java.util.Objects;

public class EdgeInsnAttr
implements IJadxAttribute {
    private final BlockNode start;
    private final BlockNode end;
    private final InsnNode insn;

    public static void addEdgeInsn(Edge edge, InsnNode insn) {
        EdgeInsnAttr.addEdgeInsn(edge.getSource(), edge.getTarget(), insn);
    }

    public static void addEdgeInsn(BlockNode start, BlockNode end, InsnNode insn) {
        EdgeInsnAttr edgeInsnAttr = new EdgeInsnAttr(start, end, insn);
        if (!start.getAll(AType.EDGE_INSN).contains(edgeInsnAttr)) {
            start.addAttr(AType.EDGE_INSN, edgeInsnAttr);
        }
        if (!end.getAll(AType.EDGE_INSN).contains(edgeInsnAttr)) {
            end.addAttr(AType.EDGE_INSN, edgeInsnAttr);
        }
    }

    private EdgeInsnAttr(BlockNode start, BlockNode end, InsnNode insn) {
        this.start = start;
        this.end = end;
        this.insn = insn;
    }

    public AType<AttrList<EdgeInsnAttr>> getAttrType() {
        return AType.EDGE_INSN;
    }

    public BlockNode getStart() {
        return this.start;
    }

    public BlockNode getEnd() {
        return this.end;
    }

    public InsnNode getInsn() {
        return this.insn;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        EdgeInsnAttr that = (EdgeInsnAttr)o15;
        return this.start.equals(that.start) && this.end.equals(that.end) && this.insn.isDeepEquals(that.insn);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.insn);
    }

    public String toString() {
        return "EDGE_INSN: " + String.valueOf(this.start) + "->" + String.valueOf(this.end) + " " + String.valueOf(this.insn);
    }
}

