/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;

final class SerializedSubject<T>
extends Subject<T>
implements AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
    final Subject<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedSubject(Subject<T> actual) {
        this.actual = actual;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.actual.subscribe(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Disposable d15) {
        boolean cancel;
        if (!this.done) {
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                        if (q15 == null) {
                            this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                        }
                        q15.add(NotificationLite.disposable(d15));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            d15.dispose();
        } else {
            this.actual.onSubscribe(d15);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t15) {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.next(t15));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t15);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t15) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                    if (q15 == null) {
                        this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                    }
                    q15.setFirst(NotificationLite.error(t15));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.actual.onError(t15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedSubject serializedSubject = this;
        synchronized (serializedSubject) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q15;
            SerializedSubject serializedSubject = this;
            synchronized (serializedSubject) {
                q15 = this.queue;
                if (q15 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q15.forEachWhile(this);
        }
    }

    @Override
    public boolean test(Object o15) {
        return NotificationLite.acceptFull(o15, this.actual);
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

