/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public enum SubscriptionHelper implements Subscription
{
    CANCELLED;


    @Override
    public void request(long n15) {
    }

    @Override
    public void cancel() {
    }

    public static boolean validate(Subscription current, Subscription next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    public static void reportSubscriptionSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Subscription already set!"));
    }

    public static boolean validate(long n15) {
        if (n15 <= 0L) {
            RxJavaPlugins.onError(new IllegalArgumentException("n > 0 required but it was " + n15));
            return false;
        }
        return true;
    }

    public static void reportMoreProduced(long n15) {
        RxJavaPlugins.onError(new ProtocolViolationException("More produced than requested: " + n15));
    }

    public static boolean set(AtomicReference<Subscription> field, Subscription s15) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s15 != null) {
                s15.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s15));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Subscription> field, Subscription s15) {
        Objects.requireNonNull(s15, "s is null");
        if (!field.compareAndSet(null, s15)) {
            s15.cancel();
            if (field.get() != CANCELLED) {
                SubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Subscription> field, Subscription s15) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s15 != null) {
                s15.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s15));
        return true;
    }

    public static boolean cancel(AtomicReference<Subscription> field) {
        Subscription current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    public static boolean deferredSetOnce(AtomicReference<Subscription> field, AtomicLong requested, Subscription s15) {
        if (SubscriptionHelper.setOnce(field, s15)) {
            long r15 = requested.getAndSet(0L);
            if (r15 != 0L) {
                s15.request(r15);
            }
            return true;
        }
        return false;
    }

    public static void deferredRequest(AtomicReference<Subscription> field, AtomicLong requested, long n15) {
        Subscription s15 = field.get();
        if (s15 != null) {
            s15.request(n15);
        } else if (SubscriptionHelper.validate(n15)) {
            long r15;
            BackpressureHelper.add(requested, n15);
            s15 = field.get();
            if (s15 != null && (r15 = requested.getAndSet(0L)) != 0L) {
                s15.request(r15);
            }
        }
    }

    public static boolean setOnce(AtomicReference<Subscription> field, Subscription s15, long request) {
        if (SubscriptionHelper.setOnce(field, s15)) {
            s15.request(request);
            return true;
        }
        return false;
    }
}

