/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;

public final class ScalarSubscription<T>
extends AtomicInteger
implements QueueSubscription<T> {
    private static final long serialVersionUID = -3830916580126663321L;
    final T value;
    final Subscriber<? super T> subscriber;
    static final int NO_REQUEST = 0;
    static final int REQUESTED = 1;
    static final int CANCELLED = 2;

    public ScalarSubscription(Subscriber<? super T> subscriber, T value) {
        this.subscriber = subscriber;
        this.value = value;
    }

    @Override
    public void request(long n15) {
        if (!SubscriptionHelper.validate(n15)) {
            return;
        }
        if (this.compareAndSet(0, 1)) {
            Subscriber<T> s15 = this.subscriber;
            s15.onNext(this.value);
            if (this.get() != 2) {
                s15.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        this.lazySet(2);
    }

    public boolean isCancelled() {
        return this.get() == 2;
    }

    @Override
    public boolean offer(T e15) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public boolean offer(T v15, T v25) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    @Nullable
    public T poll() {
        if (this.get() == 0) {
            this.lazySet(1);
            return this.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.get() != 0;
    }

    @Override
    public void clear() {
        this.lazySet(1);
    }

    @Override
    public int requestFusion(int mode) {
        return mode & 1;
    }
}

