/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.ArrayDeque;

public final class ObservableTakeLast<T>
extends AbstractObservableWithUpstream<T, T> {
    final int count;

    public ObservableTakeLast(ObservableSource<T> source, int count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new TakeLastObserver<T>(t15, this.count));
    }

    static final class TakeLastObserver<T>
    extends ArrayDeque<T>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 7240042530241604978L;
        final Observer<? super T> downstream;
        final int count;
        Disposable upstream;
        volatile boolean cancelled;

        TakeLastObserver(Observer<? super T> actual, int count) {
            this.downstream = actual;
            this.count = count;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.count == this.size()) {
                this.poll();
            }
            this.offer(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            Observer a15 = this.downstream;
            while (!this.cancelled) {
                Object v15 = this.poll();
                if (v15 == null) {
                    a15.onComplete();
                    return;
                }
                a15.onNext(v15);
            }
            return;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }
}

