/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableOnErrorNext<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;

    public ObservableOnErrorNext(ObservableSource<T> source, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier) {
        super(source);
        this.nextSupplier = nextSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        OnErrorNextObserver<? super T> parent = new OnErrorNextObserver<T>(t15, this.nextSupplier);
        t15.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
        final SequentialDisposable arbiter;
        boolean once;
        boolean done;

        OnErrorNextObserver(Observer<? super T> actual, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier) {
            this.downstream = actual;
            this.nextSupplier = nextSupplier;
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.arbiter.replace(d15);
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            ObservableSource<T> p15;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t15);
                    return;
                }
                this.downstream.onError(t15);
                return;
            }
            this.once = true;
            try {
                p15 = this.nextSupplier.apply(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(new CompositeException(t15, e15));
                return;
            }
            if (p15 == null) {
                NullPointerException npe = new NullPointerException("Observable is null");
                npe.initCause(t15);
                this.downstream.onError(npe);
                return;
            }
            p15.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.downstream.onComplete();
        }
    }
}

