/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRefCount<T>
extends Flowable<T> {
    final ConnectableFlowable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public FlowableRefCount(ConnectableFlowable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, null);
    }

    public FlowableRefCount(ConnectableFlowable<T> source, int n15, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n15;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        RefConnection conn;
        boolean connect = false;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c15;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c15 = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c15 + 1L;
            if (!conn.connected && c15 + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe((FlowableSubscriber<? super T>)new RefCountSubscriber<T>(s15, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc5) {
        SequentialDisposable sd5;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c15;
            if (this.connection == null || this.connection != rc5) {
                return;
            }
            rc5.subscriberCount = c15 = rc5.subscriberCount - 1L;
            if (c15 != 0L || !rc5.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc5);
                return;
            }
            sd5 = new SequentialDisposable();
            rc5.timer = sd5;
        }
        sd5.replace(this.scheduler.scheduleDirect(rc5, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc5) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (this.connection == rc5) {
                if (rc5.timer != null) {
                    rc5.timer.dispose();
                    rc5.timer = null;
                }
                if (--rc5.subscriberCount == 0L) {
                    this.connection = null;
                    this.source.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc5) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (rc5.subscriberCount == 0L && rc5 == this.connection) {
                this.connection = null;
                Disposable connectionObject = (Disposable)rc5.get();
                DisposableHelper.dispose(rc5);
                if (connectionObject == null) {
                    rc5.disconnectedEarly = true;
                } else {
                    this.source.reset();
                }
            }
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -7419642935409022375L;
        final Subscriber<? super T> downstream;
        final FlowableRefCount<T> parent;
        final RefConnection connection;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> actual, FlowableRefCount<T> parent, RefConnection connection) {
            this.downstream = actual;
            this.parent = parent;
            this.connection = connection;
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final FlowableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean disconnectedEarly;

        RefConnection(FlowableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Disposable t15) {
            DisposableHelper.replace(this, t15);
            FlowableRefCount<?> flowableRefCount = this.parent;
            synchronized (flowableRefCount) {
                if (this.disconnectedEarly) {
                    this.parent.source.reset();
                }
            }
        }
    }
}

