/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableGenerate<T, S>
extends Flowable<T> {
    final Supplier<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public FlowableGenerate(Supplier<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        S state;
        try {
            state = this.stateSupplier.get();
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            EmptySubscription.error(e15, s15);
            return;
        }
        s15.onSubscribe(new GeneratorSubscription<T, S>(s15, this.generator, this.disposeState, state));
    }

    static final class GeneratorSubscription<T, S>
    extends AtomicLong
    implements Emitter<T>,
    Subscription {
        private static final long serialVersionUID = 7565982551505011832L;
        final Subscriber<? super T> downstream;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorSubscription(Subscriber<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.downstream = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        @Override
        public void request(long n15) {
            if (!SubscriptionHelper.validate(n15)) {
                return;
            }
            if (BackpressureHelper.add(this, n15) != 0L) {
                return;
            }
            long e15 = 0L;
            S s15 = this.state;
            BiFunction<S, Emitter<T>, S> f15 = this.generator;
            while (true) {
                if (e15 != n15) {
                    if (this.cancelled) {
                        this.state = null;
                        this.dispose(s15);
                        return;
                    }
                    this.hasNext = false;
                    try {
                        s15 = f15.apply(s15, this);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancelled = true;
                        this.state = null;
                        this.onError(ex4);
                        this.dispose(s15);
                        return;
                    }
                    if (this.terminate) {
                        this.cancelled = true;
                        this.state = null;
                        this.dispose(s15);
                        return;
                    }
                    ++e15;
                    continue;
                }
                n15 = this.get();
                if (e15 != n15) continue;
                this.state = s15;
                n15 = this.addAndGet(-e15);
                if (n15 == 0L) break;
                e15 = 0L;
            }
        }

        private void dispose(S s15) {
            try {
                this.disposeState.accept(s15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (BackpressureHelper.add(this, 1L) == 0L) {
                    S s15 = this.state;
                    this.state = null;
                    this.dispose(s15);
                }
            }
        }

        @Override
        public void onNext(T t15) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t15 == null) {
                    this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                } else {
                    this.hasNext = true;
                    this.downstream.onNext(t15);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.terminate) {
                RxJavaPlugins.onError(t15);
            } else {
                if (t15 == null) {
                    t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
                }
                this.terminate = true;
                this.downstream.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.downstream.onComplete();
            }
        }
    }
}

