/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBuffer<T, C extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, C> {
    final int size;
    final int skip;
    final Supplier<C> bufferSupplier;

    public FlowableBuffer(Flowable<T> source, int size, int skip, Supplier<C> bufferSupplier) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super C> s15) {
        if (this.size == this.skip) {
            this.source.subscribe(new PublisherBufferExactSubscriber(s15, this.size, this.bufferSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new PublisherBufferSkipSubscriber(s15, this.size, this.skip, this.bufferSupplier));
        } else {
            this.source.subscribe(new PublisherBufferOverlappingSubscriber(s15, this.size, this.skip, this.bufferSupplier));
        }
    }

    static final class PublisherBufferOverlappingSubscriber<T, C extends Collection<? super T>>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription,
    BooleanSupplier {
        private static final long serialVersionUID = -7370244972039324525L;
        final Subscriber<? super C> downstream;
        final Supplier<C> bufferSupplier;
        final int size;
        final int skip;
        final ArrayDeque<C> buffers;
        final AtomicBoolean once;
        Subscription upstream;
        boolean done;
        int index;
        volatile boolean cancelled;
        long produced;

        PublisherBufferOverlappingSubscriber(Subscriber<? super C> actual, int size, int skip, Supplier<C> bufferSupplier) {
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.once = new AtomicBoolean();
            this.buffers = new ArrayDeque();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                if (QueueDrainHelper.postCompleteRequest(n15, this.downstream, this.buffers, this, this)) {
                    return;
                }
                if (!this.once.get() && this.once.compareAndSet(false, true)) {
                    long u15 = BackpressureHelper.multiplyCap(this.skip, n15 - 1L);
                    long r15 = BackpressureHelper.addCap(this.size, u15);
                    this.upstream.request(r15);
                } else {
                    long r16 = BackpressureHelper.multiplyCap(this.skip, n15);
                    this.upstream.request(r16);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            Collection b15;
            if (this.done) {
                return;
            }
            ArrayDeque<C> bs4 = this.buffers;
            int i15 = this.index;
            if (i15++ == 0) {
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancel();
                    this.onError(e15);
                    return;
                }
                bs4.offer(b15);
            }
            if ((b15 = (Collection)bs4.peek()).size() + 1 == this.size) {
                bs4.poll();
                b15.add(t15);
                ++this.produced;
                this.downstream.onNext(b15);
            }
            for (Collection b05 : bs4) {
                b05.add(t15);
            }
            if (i15 == this.skip) {
                i15 = 0;
            }
            this.index = i15;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.buffers.clear();
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            long p15 = this.produced;
            if (p15 != 0L) {
                BackpressureHelper.produced(this, p15);
            }
            QueueDrainHelper.postComplete(this.downstream, this.buffers, this, this);
        }
    }

    static final class PublisherBufferSkipSubscriber<T, C extends Collection<? super T>>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5616169793639412593L;
        final Subscriber<? super C> downstream;
        final Supplier<C> bufferSupplier;
        final int size;
        final int skip;
        C buffer;
        Subscription upstream;
        boolean done;
        int index;

        PublisherBufferSkipSubscriber(Subscriber<? super C> actual, int size, int skip, Supplier<C> bufferSupplier) {
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                if (this.get() == 0 && this.compareAndSet(0, 1)) {
                    long u15 = BackpressureHelper.multiplyCap(n15, this.size);
                    long v15 = BackpressureHelper.multiplyCap(this.skip - this.size, n15 - 1L);
                    this.upstream.request(BackpressureHelper.addCap(u15, v15));
                } else {
                    this.upstream.request(BackpressureHelper.multiplyCap(this.skip, n15));
                }
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            Object b15 = this.buffer;
            int i15 = this.index;
            if (i15++ == 0) {
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancel();
                    this.onError(e15);
                    return;
                }
                this.buffer = b15;
            }
            if (b15 != null) {
                b15.add(t15);
                if (b15.size() == this.size) {
                    this.buffer = null;
                    this.downstream.onNext(b15);
                }
            }
            if (i15 == this.skip) {
                i15 = 0;
            }
            this.index = i15;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.buffer = null;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b15 = this.buffer;
            this.buffer = null;
            if (b15 != null) {
                this.downstream.onNext(b15);
            }
            this.downstream.onComplete();
        }
    }

    static final class PublisherBufferExactSubscriber<T, C extends Collection<? super T>>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super C> downstream;
        final Supplier<C> bufferSupplier;
        final int size;
        C buffer;
        Subscription upstream;
        boolean done;
        int index;

        PublisherBufferExactSubscriber(Subscriber<? super C> actual, int size, Supplier<C> bufferSupplier) {
            this.downstream = actual;
            this.size = size;
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                this.upstream.request(BackpressureHelper.multiplyCap(n15, this.size));
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            Object b15 = this.buffer;
            if (b15 == null) {
                try {
                    b15 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancel();
                    this.onError(e15);
                    return;
                }
                this.buffer = b15;
            }
            b15.add(t15);
            int i15 = this.index + 1;
            if (i15 == this.size) {
                this.index = 0;
                this.buffer = null;
                this.downstream.onNext(b15);
            } else {
                this.index = i15;
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.buffer = null;
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b15 = this.buffer;
            this.buffer = null;
            if (b15 != null) {
                this.downstream.onNext(b15);
            }
            this.downstream.onComplete();
        }
    }
}

