/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.observers.LambdaConsumerIntrospection;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CallbackCompletableObserver
extends AtomicReference<Disposable>
implements CompletableObserver,
Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = -4361286194466301354L;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    public CallbackCompletableObserver(Consumer<? super Throwable> onError, Action onComplete) {
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
        this.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public void onError(Throwable e15) {
        try {
            this.onError.accept(e15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
        this.lazySet(DisposableHelper.DISPOSED);
    }

    @Override
    public void onSubscribe(Disposable d15) {
        DisposableHelper.setOnce(this, d15);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != Functions.ON_ERROR_MISSING;
    }
}

