/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.twelvemonkeys.imageio.plugins.webp.LSBBitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;

final class HuffmanTable {
    private static final int LEVEL1_BITS = 8;
    private static final int[] L_CODE_ORDER = new int[]{17, 18, 0, 1, 2, 3, 4, 5, 16, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final int[] level1 = new int[256];
    private final List<int[]> level2 = new ArrayList<int[]>();

    public HuffmanTable(LSBBitReader lSBBitReader, int n15) throws IOException {
        boolean bl4;
        boolean bl5 = bl4 = lSBBitReader.readBit() == 1;
        if (bl4) {
            int n16 = lSBBitReader.readBit() + 1;
            boolean bl6 = lSBBitReader.readBit() == 1;
            short s15 = (short)lSBBitReader.readBits(bl6 ? 8 : 1);
            if (n16 == 2) {
                short s16 = (short)lSBBitReader.readBits(8);
                for (int i15 = 0; i15 < 256; i15 += 2) {
                    this.level1[i15] = 0x10000 | s15;
                    this.level1[i15 + 1] = 0x10000 | s16;
                }
            } else {
                Arrays.fill(this.level1, (int)s15);
            }
        } else {
            int n17 = (int)(lSBBitReader.readBits(4) + 4L);
            short[] sArray = new short[L_CODE_ORDER.length];
            int n18 = 0;
            for (int i16 = 0; i16 < n17; ++i16) {
                short s17;
                sArray[HuffmanTable.L_CODE_ORDER[i16]] = s17 = (short)lSBBitReader.readBits(3);
                if (s17 <= 0) continue;
                ++n18;
            }
            short[] sArray2 = HuffmanTable.readCodeLengths(lSBBitReader, sArray, n15, n18);
            this.buildFromLengths(sArray2);
        }
    }

    private HuffmanTable(short[] sArray, int n15) {
        this.buildFromLengths(sArray, n15);
    }

    private void buildFromLengths(short[] sArray) {
        int n15 = 0;
        for (short s15 : sArray) {
            if (s15 == 0) continue;
            ++n15;
        }
        this.buildFromLengths(sArray, n15);
    }

    private void buildFromLengths(short[] sArray, int n15) {
        int n16;
        int[] nArray = new int[n15];
        int n17 = 0;
        for (n16 = 0; n16 < sArray.length; ++n16) {
            if (sArray[n16] == 0) continue;
            nArray[n17++] = sArray[n16] << 16 | n16;
        }
        if (n15 == 1) {
            Arrays.fill(this.level1, nArray[0] & 0xFFFF);
        }
        Arrays.sort(nArray);
        n16 = 0;
        int n18 = -1;
        int[] nArray2 = null;
        for (int i15 = 0; i15 < nArray.length; ++i15) {
            int n19;
            int n25 = nArray[i15];
            int n26 = n25 >>> 16;
            if (n26 <= 8) {
                for (n19 = n16; n19 < this.level1.length; n19 += 1 << n26) {
                    this.level1[n19] = n25;
                }
            } else {
                if ((n16 & 0xFF) != n18) {
                    n19 = n26;
                    int n27 = i15;
                    for (int i16 = 1 << n26 - 8; n27 < nArray.length && i16 > 0; ++n27, --i16) {
                        int n28 = nArray[n27] >>> 16;
                        while (n28 != n19) {
                            ++n19;
                            i16 <<= 1;
                        }
                    }
                    n27 = n19 - 8;
                    nArray2 = new int[1 << n27];
                    n18 = n16 & 0xFF;
                    this.level2.add(nArray2);
                    this.level1[n18] = 8 + n27 << 16 | this.level2.size() - 1;
                }
                for (n19 = n16 >>> 8; n19 < nArray2.length; n19 += 1 << n26 - 8) {
                    nArray2[n19] = n26 - 8 << 16 | n25 & 0xFFFF;
                }
            }
            n16 = this.nextCode(n16, n26);
        }
    }

    private int nextCode(int n15, int n16) {
        int n17 = ~n15 & (1 << n16) - 1;
        int n18 = Integer.highestOneBit(n17);
        return n15 & n18 - 1 | n18;
    }

    private static short[] readCodeLengths(LSBBitReader lSBBitReader, short[] sArray, int n15, int n16) throws IOException {
        int n17;
        HuffmanTable huffmanTable = new HuffmanTable(sArray, n16);
        if (lSBBitReader.readBit() == 1) {
            int n18 = (int)(2L + 2L * lSBBitReader.readBits(3));
            n17 = (int)(2L + lSBBitReader.readBits(n18));
        } else {
            n17 = n15;
        }
        short[] sArray2 = new short[n15];
        short s15 = 8;
        for (int i15 = 0; i15 < n15 && n17 > 0; ++i15, --n17) {
            int n19;
            int n25;
            short s16 = huffmanTable.readSymbol(lSBBitReader);
            if (s16 < 16) {
                sArray2[i15] = s16;
                if (s16 == 0) continue;
                s15 = s16;
                continue;
            }
            short s17 = 0;
            switch (s16) {
                case 16: {
                    s17 = s15;
                    n25 = 2;
                    n19 = 3;
                    break;
                }
                case 17: {
                    n25 = 3;
                    n19 = 3;
                    break;
                }
                case 18: {
                    n25 = 7;
                    n19 = 11;
                    break;
                }
                default: {
                    throw new IIOException("Huffman: Unreachable: Decoded Code Length > 18.");
                }
            }
            int n26 = (int)(lSBBitReader.readBits(n25) + (long)n19);
            if (i15 + n26 > n15) {
                throw new IIOException(String.format("Huffman: Code length repeat count overflows alphabet: Start index: %d, count: %d, alphabet size: %d", i15, n26, n15));
            }
            Arrays.fill(sArray2, i15, i15 + n26, s17);
            i15 += n26 - 1;
        }
        return sArray2;
    }

    public short readSymbol(LSBBitReader lSBBitReader) throws IOException {
        int n15 = (int)lSBBitReader.peekBits(8);
        int n16 = this.level1[n15];
        int n17 = n16 >>> 16;
        if (n17 > 8) {
            lSBBitReader.readBits(8);
            int n18 = (int)lSBBitReader.peekBits(n17 - 8);
            n16 = this.level2.get(n16 & 0xFFFF)[n18];
            n17 = n16 >>> 16;
        }
        lSBBitReader.readBits(n17);
        return (short)(n16 & 0xFFFF);
    }
}

