/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@J2ktIncompatible
@GwtIncompatible
public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream in4) {
        super(Preconditions.checkNotNull(in4));
    }

    @Override
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] b15) throws IOException {
        ByteStreams.readFully(this, b15);
    }

    @Override
    public void readFully(byte[] b15, int off, int len) throws IOException {
        ByteStreams.readFully(this, b15, off, len);
    }

    @Override
    public int skipBytes(int n15) throws IOException {
        return (int)this.in.skip(n15);
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedByte() throws IOException {
        int b15 = this.in.read();
        if (b15 < 0) {
            throw new EOFException();
        }
        return b15;
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedShort() throws IOException {
        byte b15 = this.readAndCheckByte();
        byte b25 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, b25, b15);
    }

    @Override
    @CanIgnoreReturnValue
    public int readInt() throws IOException {
        byte b15 = this.readAndCheckByte();
        byte b25 = this.readAndCheckByte();
        byte b35 = this.readAndCheckByte();
        byte b45 = this.readAndCheckByte();
        return Ints.fromBytes(b45, b35, b25, b15);
    }

    @Override
    @CanIgnoreReturnValue
    public long readLong() throws IOException {
        byte b15 = this.readAndCheckByte();
        byte b25 = this.readAndCheckByte();
        byte b35 = this.readAndCheckByte();
        byte b45 = this.readAndCheckByte();
        byte b55 = this.readAndCheckByte();
        byte b65 = this.readAndCheckByte();
        byte b75 = this.readAndCheckByte();
        byte b85 = this.readAndCheckByte();
        return Longs.fromBytes(b85, b75, b65, b55, b45, b35, b25, b15);
    }

    @Override
    @CanIgnoreReturnValue
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    @CanIgnoreReturnValue
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @CanIgnoreReturnValue
    public String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    @CanIgnoreReturnValue
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() throws IOException, EOFException {
        int b15 = this.in.read();
        if (b15 == -1) {
            throw new EOFException();
        }
        return (byte)b15;
    }
}

