/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class FlatWindowsNativeWindowBorder
implements FlatNativeWindowBorder.Provider {
    private final Map<Window, WndProc> windowsMap = Collections.synchronizedMap(new IdentityHashMap());
    private final EventListenerList listenerList = new EventListenerList();
    private Timer fireStateChangedTimer;
    private boolean colorizationUpToDate;
    private boolean colorizationColorAffectsBorders;
    private Color colorizationColor;
    private int colorizationColorBalance;
    private static FlatWindowsNativeWindowBorder instance;

    static FlatNativeWindowBorder.Provider getInstance() {
        if (!SystemInfo.isWindows_10_orLater) {
            return null;
        }
        if (!FlatNativeWindowsLibrary.isLoaded()) {
            return null;
        }
        if (instance == null) {
            instance = new FlatWindowsNativeWindowBorder();
        }
        return instance;
    }

    private FlatWindowsNativeWindowBorder() {
    }

    @Override
    public boolean hasCustomDecoration(Window window) {
        return this.windowsMap.containsKey(window);
    }

    @Override
    public void setHasCustomDecoration(Window window, boolean hasCustomDecoration) {
        if (hasCustomDecoration) {
            this.install(window);
        } else {
            this.uninstall(window);
        }
    }

    private void install(Window window) {
        if (!SystemInfo.isWindows_10_orLater) {
            return;
        }
        if (!(window instanceof JFrame) && !(window instanceof JDialog)) {
            return;
        }
        if (window instanceof Frame && ((Frame)window).isUndecorated() || window instanceof Dialog && ((Dialog)window).isUndecorated()) {
            return;
        }
        if (this.windowsMap.containsKey(window)) {
            return;
        }
        try {
            WndProc wndProc = new WndProc(window);
            if (wndProc.hwnd == 0L) {
                return;
            }
            this.windowsMap.put(window, wndProc);
        }
        catch (UnsatisfiedLinkError ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    private void uninstall(Window window) {
        WndProc wndProc = this.windowsMap.remove(window);
        if (wndProc != null) {
            wndProc.uninstall();
        }
    }

    @Override
    public void updateTitleBarInfo(Window window, int titleBarHeight, Predicate<Point> captionHitTestCallback, Rectangle appIconBounds, Rectangle minimizeButtonBounds, Rectangle maximizeButtonBounds, Rectangle closeButtonBounds) {
        WndProc wndProc = this.windowsMap.get(window);
        if (wndProc == null) {
            return;
        }
        wndProc.titleBarHeight = titleBarHeight;
        wndProc.captionHitTestCallback = captionHitTestCallback;
        wndProc.appIconBounds = FlatWindowsNativeWindowBorder.cloneRectange(appIconBounds);
        wndProc.minimizeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(minimizeButtonBounds);
        wndProc.maximizeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(maximizeButtonBounds);
        wndProc.closeButtonBounds = FlatWindowsNativeWindowBorder.cloneRectange(closeButtonBounds);
    }

    private static Rectangle cloneRectange(Rectangle rect) {
        return rect != null ? new Rectangle(rect) : null;
    }

    @Override
    public boolean showWindow(Window window, int cmd) {
        WndProc wndProc = this.windowsMap.get(window);
        if (wndProc == null) {
            return false;
        }
        wndProc.showWindow(wndProc.hwnd, cmd);
        return true;
    }

    @Override
    public boolean isColorizationColorAffectsBorders() {
        this.updateColorization();
        return this.colorizationColorAffectsBorders;
    }

    @Override
    public Color getColorizationColor() {
        this.updateColorization();
        return this.colorizationColor;
    }

    @Override
    public int getColorizationColorBalance() {
        this.updateColorization();
        return this.colorizationColorBalance;
    }

    private void updateColorization() {
        if (this.colorizationUpToDate) {
            return;
        }
        this.colorizationUpToDate = true;
        String subKey = "SOFTWARE\\Microsoft\\Windows\\DWM";
        int value = FlatWindowsNativeWindowBorder.registryGetIntValue(subKey, "ColorPrevalence", -1);
        this.colorizationColorAffectsBorders = value > 0;
        value = FlatWindowsNativeWindowBorder.registryGetIntValue(subKey, "ColorizationColor", -1);
        this.colorizationColor = value != -1 ? new Color(value) : null;
        this.colorizationColorBalance = FlatWindowsNativeWindowBorder.registryGetIntValue(subKey, "ColorizationColorBalance", -1);
    }

    private static native int registryGetIntValue(String var0, String var1, int var2);

    @Override
    public void addChangeListener(ChangeListener l15) {
        this.listenerList.add(ChangeListener.class, l15);
    }

    @Override
    public void removeChangeListener(ChangeListener l15) {
        this.listenerList.remove(ChangeListener.class, l15);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent e15 = new ChangeEvent(this);
        for (int i15 = 0; i15 < listeners.length; i15 += 2) {
            if (listeners[i15] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i15 + 1]).stateChanged(e15);
        }
    }

    void fireStateChangedLaterOnce() {
        EventQueue.invokeLater(() -> {
            if (this.fireStateChangedTimer != null) {
                this.fireStateChangedTimer.restart();
                return;
            }
            this.fireStateChangedTimer = new Timer(300, e15 -> {
                this.fireStateChangedTimer = null;
                this.colorizationUpToDate = false;
                this.fireStateChanged();
            });
            this.fireStateChangedTimer.setRepeats(false);
            this.fireStateChangedTimer.start();
        });
    }

    private class WndProc
    implements PropertyChangeListener {
        private static final int HTCLIENT = 1;
        private static final int HTCAPTION = 2;
        private static final int HTSYSMENU = 3;
        private static final int HTMINBUTTON = 8;
        private static final int HTMAXBUTTON = 9;
        private static final int HTTOP = 12;
        private static final int HTTOPLEFT = 13;
        private static final int HTTOPRIGHT = 14;
        private static final int HTCLOSE = 20;
        private Window window;
        private final long hwnd;
        private int titleBarHeight;
        private Predicate<Point> captionHitTestCallback;
        private Rectangle appIconBounds;
        private Rectangle minimizeButtonBounds;
        private Rectangle maximizeButtonBounds;
        private Rectangle closeButtonBounds;

        WndProc(Window window) {
            this.window = window;
            this.hwnd = this.installImpl(window);
            if (this.hwnd == 0L) {
                return;
            }
            this.updateFrame(this.hwnd, window instanceof JFrame ? ((JFrame)window).getExtendedState() : 0);
            this.updateWindowBackground();
            window.addPropertyChangeListener("background", this);
        }

        void uninstall() {
            this.window.removePropertyChangeListener("background", this);
            this.uninstallImpl(this.hwnd);
            this.window = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e15) {
            this.updateWindowBackground();
        }

        private void updateWindowBackground() {
            Color bg5 = this.window.getBackground();
            if (bg5 != null) {
                this.setWindowBackground(this.hwnd, bg5.getRed(), bg5.getGreen(), bg5.getBlue());
            }
        }

        private native long installImpl(Window var1);

        private native void uninstallImpl(long var1);

        private native void updateFrame(long var1, int var3);

        private native void setWindowBackground(long var1, int var3, int var4, int var5);

        private native void showWindow(long var1, int var3);

        private int onNcHitTest(int x15, int y15, boolean isOnResizeBorder) {
            boolean isOnTitleBar;
            Point pt4 = this.scaleDown(x15, y15);
            if (isOnResizeBorder && pt4.y > UIScale.scale(4)) {
                isOnResizeBorder = false;
            }
            if (isOnResizeBorder) {
                Insets insets = this.window.getInsets();
                if (pt4.x <= insets.left + UIScale.scale(12)) {
                    return 13;
                }
                if (pt4.x >= this.window.getWidth() - insets.right - UIScale.scale(12)) {
                    return 14;
                }
                return 12;
            }
            if (this.contains(this.appIconBounds, pt4)) {
                return 3;
            }
            if (this.contains(this.minimizeButtonBounds, pt4)) {
                return 8;
            }
            if (this.contains(this.maximizeButtonBounds, pt4)) {
                return 9;
            }
            if (this.contains(this.closeButtonBounds, pt4)) {
                return 20;
            }
            boolean bl4 = isOnTitleBar = pt4.y < this.titleBarHeight;
            if (isOnTitleBar) {
                try {
                    if (this.captionHitTestCallback != null && !this.captionHitTestCallback.test(pt4)) {
                        return 1;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return 2;
            }
            return 1;
        }

        private boolean contains(Rectangle rect, Point pt4) {
            return rect != null && rect.contains(pt4);
        }

        private Point scaleDown(int x15, int y15) {
            GraphicsConfiguration gc5 = this.window.getGraphicsConfiguration();
            if (gc5 == null) {
                return new Point(x15, y15);
            }
            AffineTransform t15 = gc5.getDefaultTransform();
            return new Point(this.clipRound((double)x15 / t15.getScaleX()), this.clipRound((double)y15 / t15.getScaleY()));
        }

        private int clipRound(double value) {
            if ((value -= 0.5) < -2.147483648E9) {
                return Integer.MIN_VALUE;
            }
            if (value > 2.147483647E9) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.ceil(value);
        }

        private boolean isFullscreen() {
            GraphicsConfiguration gc5 = this.window.getGraphicsConfiguration();
            if (gc5 == null) {
                return false;
            }
            return gc5.getDevice().getFullScreenWindow() == this.window;
        }

        private void fireStateChangedLaterOnce() {
            FlatWindowsNativeWindowBorder.this.fireStateChangedLaterOnce();
        }
    }
}

