/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;

public class FlatAscendingSortIcon
extends FlatAbstractIcon {
    protected boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    protected Color sortIconColor = UIManager.getColor("Table.sortIconColor");

    public FlatAscendingSortIcon() {
        super(10, 5, null);
    }

    @Override
    protected void paintIcon(Component c15, Graphics2D g15) {
        TableHeaderUI ui4;
        boolean chevron = this.chevron;
        Color sortIconColor = this.sortIconColor;
        JTableHeader tableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, c15);
        if (tableHeader != null && (ui4 = tableHeader.getUI()) instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI fui = (FlatTableHeaderUI)ui4;
            if (fui.arrowType != null) {
                chevron = FlatUIUtils.isChevron(fui.arrowType);
            }
            if (fui.sortIconColor != null) {
                sortIconColor = fui.sortIconColor;
            }
        }
        g15.setColor(sortIconColor);
        this.paintArrow(c15, g15, chevron);
    }

    protected void paintArrow(Component c15, Graphics2D g15, boolean chevron) {
        if (chevron) {
            Path2D path = FlatUIUtils.createPath(false, 1.0, 4.0, 5.0, 0.0, 9.0, 4.0);
            g15.setStroke(new BasicStroke(1.0f));
            g15.draw(path);
        } else {
            g15.fill(FlatUIUtils.createPath(0.5, 5.0, 5.0, 0.0, 9.5, 5.0));
        }
    }
}

