/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class FlatInspector {
    private static final Integer HIGHLIGHT_LAYER = JLayeredPane.POPUP_LAYER - 1;
    private static final int KEY_MODIFIERS_MASK = 960;
    private final JRootPane rootPane;
    private final MouseMotionListener mouseMotionListener;
    private final AWTEventListener keyListener;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final WindowListener windowListener;
    private Window window;
    private boolean enabled;
    private Object oldGlassPaneFullHeight;
    private Component lastComponent;
    private int lastX;
    private int lastY;
    private int inspectParentLevel;
    private boolean wasModifierKeyPressed;
    private boolean showClassHierarchy;
    private long lastWhen;
    private JComponent highlightFigure;
    private Popup popup;

    public static void install(String activationKeys) {
        if (activationKeys == null) {
            activationKeys = "ctrl shift alt X";
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(activationKeys);
        Toolkit.getDefaultToolkit().addAWTEventListener(e15 -> {
            if (e15.getID() == 402 && ((KeyEvent)e15).getKeyCode() == keyStroke.getKeyCode() && (((KeyEvent)e15).getModifiersEx() & 0x3C0) == (keyStroke.getModifiers() & 0x3C0)) {
                Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                RootPaneContainer rootPaneContainer = null;
                if (activeWindow instanceof RootPaneContainer) {
                    rootPaneContainer = (RootPaneContainer)((Object)activeWindow);
                } else {
                    for (Component child : activeWindow.getComponents()) {
                        if (!(child instanceof RootPaneContainer)) continue;
                        rootPaneContainer = (RootPaneContainer)((Object)child);
                        break;
                    }
                }
                if (rootPaneContainer != null) {
                    JRootPane rootPane = rootPaneContainer.getRootPane();
                    FlatInspector inspector = (FlatInspector)rootPane.getClientProperty(FlatInspector.class);
                    if (inspector == null) {
                        inspector = new FlatInspector(rootPane);
                        rootPane.putClientProperty(FlatInspector.class, inspector);
                        inspector.setEnabled(true);
                    } else {
                        inspector.setEnabled(false);
                        rootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        }, 8L);
    }

    public FlatInspector(JRootPane rootPane) {
        this.rootPane = rootPane;
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e15) {
                FlatInspector.this.lastX = e15.getX();
                FlatInspector.this.lastY = e15.getY();
                FlatInspector.this.inspect(FlatInspector.this.lastX, FlatInspector.this.lastY);
            }
        };
        this.keyListener = e15 -> {
            KeyEvent keyEvent = (KeyEvent)e15;
            int keyCode = keyEvent.getKeyCode();
            int id5 = e15.getID();
            if (id5 == 401) {
                if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
                    this.wasModifierKeyPressed = true;
                }
            } else if (id5 == 402 && this.wasModifierKeyPressed) {
                int parentLevel;
                if (keyEvent.getWhen() - this.lastWhen <= 5L) {
                    return;
                }
                this.lastWhen = keyEvent.getWhen();
                if (keyCode == 17) {
                    ++this.inspectParentLevel;
                    parentLevel = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > parentLevel) {
                        this.inspectParentLevel = parentLevel;
                    }
                } else if (keyCode == 16 && this.inspectParentLevel > 0) {
                    --this.inspectParentLevel;
                    parentLevel = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > parentLevel) {
                        this.inspectParentLevel = Math.max(parentLevel - 1, 0);
                        this.inspect(this.lastX, this.lastY);
                    }
                } else if (keyCode == 18 && this.lastComponent != null) {
                    this.showClassHierarchy = !this.showClassHierarchy;
                    this.showToolTip(this.lastComponent, this.lastX, this.lastY, this.inspectParentLevel);
                }
            }
            if (keyCode == 27) {
                keyEvent.consume();
                if (id5 == 401) {
                    this.setEnabled(false);
                    FlatInspector inspector = (FlatInspector)rootPane.getClientProperty(FlatInspector.class);
                    if (inspector == this) {
                        rootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e15) {
                FlatInspector.this.update();
            }

            @Override
            public void windowDeactivated(WindowEvent e15) {
                FlatInspector.this.hidePopup();
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener l15) {
        this.propertyChangeSupport.addPropertyChangeListener(l15);
    }

    public void removePropertyChangeListener(PropertyChangeListener l15) {
        this.propertyChangeSupport.removePropertyChangeListener(l15);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.oldGlassPaneFullHeight = this.rootPane.getClientProperty("JRootPane.glassPaneFullHeight");
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", true);
            this.rootPane.validate();
        } else {
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", this.oldGlassPaneFullHeight);
        }
        ((JComponent)this.rootPane.getGlassPane()).setOpaque(false);
        this.rootPane.getGlassPane().setVisible(enabled);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (enabled) {
            toolkit.addAWTEventListener(this.keyListener, 8L);
        } else {
            toolkit.removeAWTEventListener(this.keyListener);
        }
        if (enabled) {
            this.rootPane.getGlassPane().addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.rootPane.getGlassPane().removeMouseMotionListener(this.mouseMotionListener);
        }
        if (enabled) {
            this.window = SwingUtilities.windowForComponent(this.rootPane);
            if (this.window != null) {
                this.window.addWindowListener(this.windowListener);
            }
        } else if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window = null;
        }
        if (enabled) {
            Point pt4 = new Point(MouseInfo.getPointerInfo().getLocation());
            SwingUtilities.convertPointFromScreen(pt4, this.rootPane);
            this.lastX = pt4.x;
            this.lastY = pt4.y;
            this.inspect(this.lastX, this.lastY);
        } else {
            this.lastComponent = null;
            this.inspectParentLevel = 0;
            if (this.highlightFigure != null) {
                this.highlightFigure.getParent().remove(this.highlightFigure);
            }
            this.highlightFigure = null;
            this.hidePopup();
        }
        this.propertyChangeSupport.firePropertyChange("enabled", !enabled, enabled);
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void update() {
        if (!this.rootPane.getGlassPane().isVisible()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.setEnabled(false);
            this.setEnabled(true);
            this.inspect(this.lastX, this.lastY);
        });
    }

    private int inspect(int x15, int y15) {
        Container parent;
        Point pt4 = SwingUtilities.convertPoint(this.rootPane.getGlassPane(), x15, y15, this.rootPane);
        Component c15 = this.getDeepestComponentAt(this.rootPane, pt4.x, pt4.y);
        int parentLevel = 0;
        for (int i15 = 0; i15 < this.inspectParentLevel && c15 != null && (parent = c15.getParent()) != null; ++i15) {
            c15 = parent;
            ++parentLevel;
        }
        if (c15 == this.lastComponent) {
            return parentLevel;
        }
        this.lastComponent = c15;
        this.highlight(c15);
        this.showToolTip(c15, x15, y15, parentLevel);
        return parentLevel;
    }

    private Component getDeepestComponentAt(Component parent, int x15, int y15) {
        if (!parent.contains(x15, y15)) {
            return null;
        }
        if (parent instanceof Container) {
            for (Component child : ((Container)parent).getComponents()) {
                Component c15;
                if (child == null || !child.isVisible()) continue;
                int cx4 = x15 - child.getX();
                int cy4 = y15 - child.getY();
                Component component = c15 = child instanceof Container ? this.getDeepestComponentAt(child, cx4, cy4) : child.getComponentAt(cx4, cy4);
                if (c15 == null || !c15.isVisible() || c15 == this.highlightFigure || c15.getParent() instanceof JRootPane && c15 == ((JRootPane)c15.getParent()).getGlassPane() || "com.formdev.flatlaf.ui.FlatWindowResizer".equals(c15.getClass().getName())) continue;
                return c15;
            }
        }
        return parent;
    }

    private void highlight(Component c15) {
        if (this.highlightFigure == null) {
            this.highlightFigure = this.createHighlightFigure();
            this.rootPane.getLayeredPane().add((Component)this.highlightFigure, HIGHLIGHT_LAYER);
        }
        this.highlightFigure.setVisible(c15 != null);
        if (c15 != null) {
            Insets insets = this.rootPane.getInsets();
            this.highlightFigure.setBounds(new Rectangle(SwingUtilities.convertPoint(c15, -insets.left, -insets.top, this.rootPane), c15.getSize()));
        }
    }

    private JComponent createHighlightFigure() {
        JComponent c15 = new JComponent(){

            @Override
            protected void paintComponent(Graphics g15) {
                g15.setColor(this.getBackground());
                g15.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            protected void paintBorder(Graphics g15) {
                Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
                super.paintBorder(g15);
                FlatUIUtils.resetRenderingHints(g15, oldRenderingHints);
            }
        };
        c15.setBackground(new Color(255, 0, 0, 32));
        c15.setBorder(new LineBorder(Color.red));
        return c15;
    }

    private void showToolTip(Component c15, int x15, int y15, int parentLevel) {
        this.hidePopup();
        if (c15 == null || this.window != null && !this.window.isActive()) {
            return;
        }
        JToolTip tip = new JToolTip();
        tip.setTipText(FlatInspector.buildToolTipText(c15, parentLevel, this.showClassHierarchy));
        tip.putClientProperty("Popup.forceHeavyWeight", true);
        Point pt4 = new Point(x15, y15);
        SwingUtilities.convertPointToScreen(pt4, this.rootPane.getGlassPane());
        int tx4 = pt4.x + UIScale.scale(8);
        int ty4 = pt4.y + UIScale.scale(16);
        Dimension size = tip.getPreferredSize();
        GraphicsConfiguration gc5 = this.rootPane.getGraphicsConfiguration();
        if (gc5 != null) {
            Rectangle visibleRect = gc5.getBounds();
            if (tx4 + size.width > visibleRect.x + visibleRect.width) {
                tx4 -= size.width + UIScale.scale(16);
            }
            if (ty4 + size.height > visibleRect.y + visibleRect.height) {
                ty4 -= size.height + UIScale.scale(32);
            }
            if (tx4 < visibleRect.x) {
                tx4 = visibleRect.x;
            }
            if (ty4 < visibleRect.y) {
                ty4 = visibleRect.y;
            }
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(c15, tip, tx4, ty4);
        this.popup.show();
    }

    private static String buildToolTipText(Component c15, int parentLevel, boolean classHierarchy) {
        Object style;
        LayoutManager layout;
        StringBuilder buf = new StringBuilder(1500);
        buf.append("<html><style>");
        buf.append("td { padding: 0 10 0 0; }");
        buf.append("</style><table>");
        FlatInspector.appendRow(buf, "Class", FlatInspector.toString(c15.getClass(), classHierarchy));
        FlatInspector.appendRow(buf, "Size", c15.getWidth() + ", " + c15.getHeight() + "&nbsp;&nbsp; @ " + c15.getX() + ", " + c15.getY());
        if (c15 instanceof Container) {
            FlatInspector.appendRow(buf, "Insets", FlatInspector.toString(((Container)c15).getInsets()));
        }
        Insets margin = null;
        if (c15 instanceof AbstractButton) {
            margin = ((AbstractButton)c15).getMargin();
        } else if (c15 instanceof JTextComponent) {
            margin = ((JTextComponent)c15).getMargin();
        } else if (c15 instanceof JMenuBar) {
            margin = ((JMenuBar)c15).getMargin();
        } else if (c15 instanceof JToolBar) {
            margin = ((JToolBar)c15).getMargin();
        }
        if (margin != null) {
            FlatInspector.appendRow(buf, "Margin", FlatInspector.toString(margin));
        }
        if (c15 instanceof JComponent) {
            Insets visualPadding;
            Object value = ((JComponent)c15).getClientProperty(MigLayoutVisualPadding.VISUAL_PADDING_PROPERTY);
            Insets insets = value instanceof int[] ? new Insets(((int[])value)[0], ((int[])value)[1], ((int[])value)[2], ((int[])value)[3]) : (visualPadding = value instanceof Insets ? (Insets)value : null);
            if (visualPadding != null) {
                FlatInspector.appendRow(buf, "Mig visual padding", FlatInspector.toString(visualPadding));
            }
        }
        Dimension prefSize = c15.getPreferredSize();
        Dimension minSize = c15.getMinimumSize();
        Dimension maxSize = c15.getMaximumSize();
        FlatInspector.appendRow(buf, "Pref size", prefSize.width + ", " + prefSize.height);
        FlatInspector.appendRow(buf, "Min size", minSize.width + ", " + minSize.height);
        FlatInspector.appendRow(buf, "Max size", maxSize.width + ", " + maxSize.height);
        if (c15 instanceof JComponent) {
            FlatInspector.appendRow(buf, "Border", FlatInspector.toString(((JComponent)c15).getBorder(), classHierarchy));
        }
        FlatInspector.appendRow(buf, "Background", FlatInspector.toString(c15.getBackground()) + (c15.isBackgroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(buf, "Foreground", FlatInspector.toString(c15.getForeground()) + (c15.isForegroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(buf, "Font", FlatInspector.toString(c15.getFont()) + (c15.isFontSet() ? "" : "  NOT SET"));
        if (c15 instanceof JComponent) {
            try {
                Object ui4;
                if (SystemInfo.isJava_9_orLater) {
                    Method m15 = JComponent.class.getMethod("getUI", new Class[0]);
                    ui4 = m15.invoke((Object)c15, new Object[0]);
                } else {
                    Field f15 = JComponent.class.getDeclaredField("ui");
                    f15.setAccessible(true);
                    ui4 = f15.get(c15);
                }
                FlatInspector.appendRow(buf, "UI", ui4 != null ? FlatInspector.toString(ui4.getClass(), classHierarchy) : "null");
            }
            catch (Exception ui4) {
                // empty catch block
            }
        }
        if (c15 instanceof Container && (layout = ((Container)c15).getLayout()) != null) {
            FlatInspector.appendRow(buf, "Layout", FlatInspector.toString(layout.getClass(), classHierarchy));
        }
        FlatInspector.appendRow(buf, "Enabled", String.valueOf(c15.isEnabled()));
        FlatInspector.appendRow(buf, "Opaque", String.valueOf(c15.isOpaque()) + (c15 instanceof JComponent && FlatUIUtils.hasOpaqueBeenExplicitlySet((JComponent)c15) ? " EXPLICIT" : ""));
        if (c15 instanceof AbstractButton) {
            FlatInspector.appendRow(buf, "ContentAreaFilled", String.valueOf(((AbstractButton)c15).isContentAreaFilled()));
        }
        FlatInspector.appendRow(buf, "Focusable", String.valueOf(c15.isFocusable()));
        FlatInspector.appendRow(buf, "Left-to-right", String.valueOf(c15.getComponentOrientation().isLeftToRight()));
        FlatInspector.appendRow(buf, "Parent", c15.getParent() != null ? FlatInspector.toString(c15.getParent().getClass(), classHierarchy) : "null");
        if (c15 instanceof JComponent && (style = ((JComponent)c15).getClientProperty("FlatLaf.style")) != null) {
            FlatInspector.appendRow(buf, "FlatLaf Style", style.toString());
        }
        buf.append("<tr><td colspan=\"2\">");
        if (parentLevel > 0) {
            buf.append("<br>Parent level: " + parentLevel);
        }
        buf.append("<br>(").append(parentLevel > 0 ? "press <b>Ctrl/Shift</b> to increase/decrease level" : "press <b>Ctrl</b> key to inspect parent").append("; &nbsp;").append(classHierarchy ? "press <b>Alt</b> key to hide class hierarchy" : "press <b>Alt</b> key to show class hierarchy").append(')');
        buf.append("</td></tr>");
        buf.append("</table></html>");
        return buf.toString();
    }

    private static void appendRow(StringBuilder buf, String key, String value) {
        buf.append("<tr><td valign=\"top\">").append(key).append(":</td><td>").append(value).append("</td></tr>");
    }

    private static String toString(Class<?> cls, boolean classHierarchy) {
        StringBuilder buf = new StringBuilder(100);
        int level = 0;
        while (cls != null) {
            if (level > 0) {
                if (cls == Object.class) break;
                buf.append("<br>&nbsp;");
                for (int i15 = 1; i15 < level; ++i15) {
                    buf.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                buf.append("\u2570 ");
            }
            ++level;
            String name = cls.getName();
            int dot = name.lastIndexOf(46);
            String pkg = dot >= 0 ? name.substring(0, dot) : "-";
            String simpleName = dot >= 0 ? name.substring(dot + 1) : name;
            buf.append(simpleName).append(' ').append(FlatInspector.toDimmedText("(" + pkg + ")"));
            if (UIResource.class.isAssignableFrom(cls)) {
                buf.append(" UI");
            }
            if (!classHierarchy) break;
            cls = cls.getSuperclass();
        }
        return buf.toString();
    }

    private static String toString(Insets insets) {
        if (insets == null) {
            return "null";
        }
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + (insets instanceof UIResource ? " UI" : "");
    }

    private static String toString(Color c15) {
        if (c15 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(150);
        buf.append("<tt>");
        buf.append(c15.getAlpha() != 255 ? String.format("#%06x%02x", c15.getRGB() & 0xFFFFFF, c15.getRGB() >> 24 & 0xFF) : String.format("#%06x", c15.getRGB() & 0xFFFFFF));
        buf.append("</tt>");
        if (c15 instanceof UIResource) {
            buf.append(" UI");
        }
        buf.append("&nbsp; &nbsp;").append("<span style=\"background: ").append(String.format("#%06x", c15.getRGB() & 0xFFFFFF)).append(";\">").append("&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;").append("</span>");
        if (c15.getAlpha() != 255) {
            buf.append(" ").append(Math.round((float)c15.getAlpha() / 2.55f)).append('%');
        }
        return buf.toString();
    }

    private static String toString(Font f15) {
        if (f15 == null) {
            return "null";
        }
        return f15.getFamily() + " " + f15.getSize() + " " + f15.getStyle() + (f15 instanceof UIResource ? " UI" : "");
    }

    private static String toString(Border b15, boolean classHierarchy) {
        if (b15 == null) {
            return "null";
        }
        String s15 = FlatInspector.toString(b15.getClass(), classHierarchy);
        if (b15 instanceof EmptyBorder) {
            String borderInsets = " (" + FlatInspector.toString(((EmptyBorder)b15).getBorderInsets()) + ')';
            int brIndex = s15.indexOf("<br>");
            s15 = brIndex >= 0 ? s15.substring(0, brIndex) + borderInsets + s15.substring(brIndex) : s15 + borderInsets;
        }
        return s15;
    }

    private static String toDimmedText(String text) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            color = UIManager.getColor("Label.disabledText");
        }
        if (color == null) {
            color = Color.GRAY;
        }
        return String.format("<span color=\"#%06x\">%s</span>", color.getRGB() & 0xFFFFFF, text);
    }
}

