/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali;

import com.android.tools.smali.dexlib2.DexFileFactory;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedParameter;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

@Parameters(commandDescription="Lists the dex files in an apk/oat file.")
@ExtendedParameters(commandName="dex", commandAliases={"d"})
public class ListDexCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @Parameter(description="An apk or oat file.")
    @ExtendedParameter(argumentNames={"file"})
    private List<String> inputList = Lists.newArrayList();

    public ListDexCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        List<String> entries;
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = this.inputList.get(0);
        File file2 = new File(input);
        if (!file2.exists()) {
            System.err.println(String.format("Could not find the file: %s", input));
            System.exit(-1);
        }
        try {
            MultiDexContainer<? extends DexBackedDexFile> container = DexFileFactory.loadDexContainer(file2, Opcodes.getDefault());
            entries = container.getDexEntryNames();
        }
        catch (IOException ex4) {
            throw new RuntimeException(ex4);
        }
        for (String entry : entries) {
            System.out.println(entry);
        }
    }
}

