/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.util.MutabilityControl;

public final class RegisterSpecSet
extends MutabilityControl {
    public static final RegisterSpecSet EMPTY = new RegisterSpecSet(0);
    private final RegisterSpec[] specs;
    private int size;

    public RegisterSpecSet(int maxSize) {
        super(maxSize != 0);
        this.specs = new RegisterSpec[maxSize];
        this.size = 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegisterSpecSet)) {
            return false;
        }
        RegisterSpecSet otherSet = (RegisterSpecSet)other;
        int len = this.specs.length;
        RegisterSpec[] otherSpecs = otherSet.specs;
        if (len != otherSpecs.length || this.size() != otherSet.size()) {
            return false;
        }
        for (int i15 = 0; i15 < len; ++i15) {
            RegisterSpec s15 = this.specs[i15];
            RegisterSpec s25 = otherSpecs[i15];
            if (s15 == s25 || s15 != null && s15.equals(s25)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len = this.specs.length;
        int hash = 0;
        for (int i15 = 0; i15 < len; ++i15) {
            RegisterSpec spec = this.specs[i15];
            int oneHash = spec == null ? 0 : spec.hashCode();
            hash = hash * 31 + oneHash;
        }
        return hash;
    }

    public String toString() {
        int len = this.specs.length;
        StringBuilder sb5 = new StringBuilder(len * 25);
        sb5.append('{');
        boolean any = false;
        for (int i15 = 0; i15 < len; ++i15) {
            RegisterSpec spec = this.specs[i15];
            if (spec == null) continue;
            if (any) {
                sb5.append(", ");
            } else {
                any = true;
            }
            sb5.append(spec);
        }
        sb5.append('}');
        return sb5.toString();
    }

    public int getMaxSize() {
        return this.specs.length;
    }

    public int size() {
        int result = this.size;
        if (result < 0) {
            int len = this.specs.length;
            result = 0;
            for (int i15 = 0; i15 < len; ++i15) {
                if (this.specs[i15] == null) continue;
                ++result;
            }
            this.size = result;
        }
        return result;
    }

    public RegisterSpec get(int reg) {
        try {
            return this.specs[reg];
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public RegisterSpec get(RegisterSpec spec) {
        return this.get(spec.getReg());
    }

    public RegisterSpec findMatchingLocal(RegisterSpec spec) {
        for (RegisterSpec s15 : this.specs) {
            if (s15 == null || !spec.matchesVariable(s15)) continue;
            return s15;
        }
        return null;
    }

    public RegisterSpec localItemToSpec(LocalItem local) {
        for (RegisterSpec spec : this.specs) {
            if (spec == null || !local.equals(spec.getLocalItem())) continue;
            return spec;
        }
        return null;
    }

    public void remove(RegisterSpec toRemove) {
        try {
            this.specs[toRemove.getReg()] = null;
            this.size = -1;
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public void put(RegisterSpec spec) {
        this.throwIfImmutable();
        if (spec == null) {
            throw new NullPointerException("spec == null");
        }
        this.size = -1;
        try {
            int prevReg;
            RegisterSpec prevSpec;
            int reg = spec.getReg();
            this.specs[reg] = spec;
            if (reg > 0 && (prevSpec = this.specs[prevReg = reg - 1]) != null && prevSpec.getCategory() == 2) {
                this.specs[prevReg] = null;
            }
            if (spec.getCategory() == 2) {
                this.specs[reg + 1] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new IllegalArgumentException("spec.getReg() out of range");
        }
    }

    public void putAll(RegisterSpecSet set) {
        int max = set.getMaxSize();
        for (int i15 = 0; i15 < max; ++i15) {
            RegisterSpec spec = set.get(i15);
            if (spec == null) continue;
            this.put(spec);
        }
    }

    public void intersect(RegisterSpecSet other, boolean localPrimary) {
        int i15;
        this.throwIfImmutable();
        RegisterSpec[] otherSpecs = other.specs;
        int thisLen = this.specs.length;
        int len = Math.min(thisLen, otherSpecs.length);
        this.size = -1;
        for (i15 = 0; i15 < len; ++i15) {
            RegisterSpec intersection;
            RegisterSpec spec = this.specs[i15];
            if (spec == null || (intersection = spec.intersect(otherSpecs[i15], localPrimary)) == spec) continue;
            this.specs[i15] = intersection;
        }
        for (i15 = len; i15 < thisLen; ++i15) {
            this.specs[i15] = null;
        }
    }

    public RegisterSpecSet withOffset(int delta) {
        int len = this.specs.length;
        RegisterSpecSet result = new RegisterSpecSet(len + delta);
        for (int i15 = 0; i15 < len; ++i15) {
            RegisterSpec spec = this.specs[i15];
            if (spec == null) continue;
            result.put(spec.withOffset(delta));
        }
        result.size = this.size;
        if (this.isImmutable()) {
            result.setImmutable();
        }
        return result;
    }

    public RegisterSpecSet mutableCopy() {
        int len = this.specs.length;
        RegisterSpecSet copy = new RegisterSpecSet(len);
        for (int i15 = 0; i15 < len; ++i15) {
            RegisterSpec spec = this.specs[i15];
            if (spec == null) continue;
            copy.put(spec);
        }
        copy.size = this.size;
        return copy;
    }
}

