/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public final class ClassDefsSection
extends UniformItemSection {
    private final TreeMap<Type, ClassDefItem> classDefs = new TreeMap();
    private ArrayList<ClassDefItem> orderedDefs = null;

    public ClassDefsSection(DexFile file2) {
        super("class_defs", file2, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        if (this.orderedDefs != null) {
            return this.orderedDefs;
        }
        return this.classDefs.values();
    }

    @Override
    public IndexedItem get(Constant cst) {
        if (cst == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        Type type = ((CstType)cst).getClassType();
        IndexedItem result = this.classDefs.get(type);
        if (result == null) {
            throw new IllegalArgumentException("not found");
        }
        return result;
    }

    public void writeHeaderPart(AnnotatedOutput out) {
        int offset;
        this.throwIfNotPrepared();
        int sz4 = this.classDefs.size();
        int n15 = offset = sz4 == 0 ? 0 : this.getFileOffset();
        if (out.annotates()) {
            out.annotate(4, "class_defs_size: " + Hex.u4(sz4));
            out.annotate(4, "class_defs_off:  " + Hex.u4(offset));
        }
        out.writeInt(sz4);
        out.writeInt(offset);
    }

    public void add(ClassDefItem clazz) {
        Type type;
        try {
            type = clazz.getThisClass().getClassType();
        }
        catch (NullPointerException ex4) {
            throw new NullPointerException("clazz == null");
        }
        this.throwIfPrepared();
        if (this.classDefs.get(type) != null) {
            throw new IllegalArgumentException("already added: " + type);
        }
        this.classDefs.put(type, clazz);
    }

    @Override
    protected void orderItems() {
        int sz4 = this.classDefs.size();
        int idx = 0;
        this.orderedDefs = new ArrayList(sz4);
        for (Type type : this.classDefs.keySet()) {
            idx = this.orderItems0(type, idx, sz4 - idx);
        }
    }

    private int orderItems0(Type type, int idx, int maxDepth) {
        ClassDefItem c15 = this.classDefs.get(type);
        if (c15 == null || c15.hasIndex()) {
            return idx;
        }
        if (maxDepth < 0) {
            throw new RuntimeException("class circularity with " + type);
        }
        --maxDepth;
        CstType superclassCst = c15.getSuperclass();
        if (superclassCst != null) {
            Type superclass = superclassCst.getClassType();
            idx = this.orderItems0(superclass, idx, maxDepth);
        }
        TypeList interfaces = c15.getInterfaces();
        int sz4 = interfaces.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            idx = this.orderItems0(interfaces.getType(i15), idx, maxDepth);
        }
        c15.setIndex(idx);
        this.orderedDefs.add(c15);
        return idx + 1;
    }
}

