/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator2
implements Abbreviator {
    final int targetLength;

    public TargetLengthBasedClassNameAbbreviator2(int targetLength) {
        this.targetLength = targetLength;
    }

    @Override
    public String abbreviate(String fqClassName) {
        StringBuilder buf = new StringBuilder(this.targetLength);
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int inLen = fqClassName.length();
        if (inLen < this.targetLength) {
            return fqClassName;
        }
        int[] dotIndexesArray = new int[16];
        int[] lengthArray = new int[17];
        int dotCount = TargetLengthBasedClassNameAbbreviator2.computeDotIndexes(fqClassName, dotIndexesArray);
        if (dotCount == 0) {
            return fqClassName;
        }
        this.computeLengthArray(fqClassName, dotIndexesArray, lengthArray, dotCount);
        for (int i15 = 0; i15 <= dotCount; ++i15) {
            if (i15 == 0) {
                buf.append(fqClassName.substring(0, lengthArray[i15] - 1));
                continue;
            }
            buf.append(fqClassName.substring(dotIndexesArray[i15 - 1], dotIndexesArray[i15 - 1] + lengthArray[i15]));
        }
        return buf.toString();
    }

    static int computeDotIndexes(String className, int[] dotArray) {
        int dotCount;
        int k15 = 0;
        for (dotCount = 0; (k15 = className.indexOf(46, k15)) != -1 && dotCount < 16; ++dotCount) {
            dotArray[dotCount] = k15++;
        }
        return dotCount;
    }

    void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        int toTrim = className.length() - this.targetLength;
        for (int i15 = 0; i15 < dotCount; ++i15) {
            int previousDotPosition = i15 == 0 ? -1 : dotArray[i15 - 1];
            int charactersInSegment = dotArray[i15] - previousDotPosition - 1;
            int len = toTrim > 0 ? (charactersInSegment < 1 ? charactersInSegment : 1) : charactersInSegment;
            toTrim -= charactersInSegment - len;
            lengthArray[i15] = len + 1;
        }
        int lastDotIndex = dotCount - 1;
        lengthArray[dotCount] = className.length() - dotArray[lastDotIndex];
    }

    static void printArray(String msg, int[] ia5) {
        System.out.print(msg);
        for (int i15 = 0; i15 < ia5.length; ++i15) {
            if (i15 == 0) {
                System.out.print(ia5[i15]);
                continue;
            }
            System.out.print(", " + ia5[i15]);
        }
        System.out.println();
    }
}

