/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.layout;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import org.slf4j.event.KeyValuePair;

public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    static final char DOUBLE_QUOTE_CHAR = '\"';

    @Override
    public void start() {
        this.tpc.start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder sb5 = new StringBuilder();
        long timestamp = event.getTimeStamp();
        sb5.append(this.cachingDateFormatter.format(timestamp));
        sb5.append(" [");
        sb5.append(event.getThreadName());
        sb5.append("] ");
        sb5.append(event.getLevel().toString());
        sb5.append(" ");
        sb5.append(event.getLoggerName());
        sb5.append(" -");
        this.kvp(event, sb5);
        sb5.append("- ");
        sb5.append(event.getFormattedMessage());
        sb5.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy tp4 = event.getThrowableProxy();
        if (tp4 != null) {
            String stackTrace = this.tpc.convert(event);
            sb5.append(stackTrace);
        }
        return sb5.toString();
    }

    private void kvp(ILoggingEvent event, StringBuilder sb5) {
        List<KeyValuePair> kvpList = event.getKeyValuePairs();
        if (kvpList == null || kvpList.isEmpty()) {
            return;
        }
        int len = kvpList.size();
        for (int i15 = 0; i15 < len; ++i15) {
            KeyValuePair kvp = kvpList.get(i15);
            if (i15 != 0) {
                sb5.append(' ');
            }
            sb5.append(String.valueOf(kvp.key));
            sb5.append('=');
            sb5.append('\"');
            sb5.append(String.valueOf(kvp.value));
            sb5.append('\"');
        }
    }
}

