/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int n15, boolean bl4) {
        switch (n15) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n15 < 32 || n15 > 126) {
            if (n15 > 255) {
                String string = Integer.toString(n15, 16);
                while (string.length() < 4) {
                    string = '0' + string;
                }
                return "\\u" + string;
            }
            return "\\" + Integer.toString(n15, 8);
        }
        return String.valueOf((char)n15);
    }

    public String escapeString(String string) {
        String string2 = new String();
        for (int i15 = 0; i15 < string.length(); ++i15) {
            string2 = string2 + this.escapeChar(string.charAt(i15), false);
        }
        return string2;
    }

    public String literalChar(int n15) {
        String string = "0x" + Integer.toString(n15, 16);
        if (n15 >= 0 && n15 <= 126) {
            string = string + " /* '" + this.escapeChar(n15, true) + "' */ ";
        }
        return string;
    }

    public String literalString(String string) {
        return "\"" + this.escapeString(string) + "\"";
    }
}

