/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate.jama;

import tim.prune.function.estimate.jama.QRDecomposition;

public class Matrix {
    private double[][] _matrix;
    private int _m;
    private int _n;

    public Matrix(int n, int n2) {
        this._m = n;
        this._n = n2;
        this._matrix = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this._m = dArray.length;
        this._n = dArray[0].length;
        int n = 0;
        while (n < this._m) {
            if (dArray[n].length != this._n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++n;
        }
        this._matrix = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this._matrix = dArray;
        this._m = n;
        this._n = n2;
    }

    public void setValue(int n, int n2, double d) {
        this._matrix[n][n2] = d;
    }

    public double[][] getArray() {
        return this._matrix;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this._m][this._n];
        int n = 0;
        while (n < this._m) {
            int n2 = 0;
            while (n2 < this._n) {
                dArray[n][n2] = this._matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public double get(int n, int n2) {
        return this._matrix[n][n2];
    }

    public int getNumRows() {
        return this._m;
    }

    public int getNumColumns() {
        return this._n;
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            int n5 = n;
            while (n5 <= n2) {
                int n6 = n3;
                while (n6 <= n4) {
                    dArray[n5 - n][n6 - n3] = this._matrix[n5][n6];
                    ++n6;
                }
                ++n5;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix times(Matrix matrix) {
        if (matrix._m != this._n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this._m, matrix._n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this._n];
        int n = 0;
        while (n < matrix._n) {
            int n2 = 0;
            while (n2 < this._n) {
                dArray2[n2] = matrix._matrix[n2][n];
                ++n2;
            }
            n2 = 0;
            while (n2 < this._m) {
                double[] dArray3 = this._matrix[n2];
                double d = 0.0;
                int n3 = 0;
                while (n3 < this._n) {
                    d += dArray3[n3] * dArray2[n3];
                    ++n3;
                }
                dArray[n2][n] = d;
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix minus(Matrix matrix) {
        if (matrix._m != this._m || matrix._n != this._n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this._m, this._n);
        int n = 0;
        while (n < this._m) {
            int n2 = 0;
            while (n2 < this._n) {
                matrix2.setValue(n, n2, this.get(n, n2) - matrix.get(n, n2));
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix divideEach(Matrix matrix) {
        if (matrix._m != this._m || matrix._n != this._n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this._m, this._n);
        int n = 0;
        while (n < this._m) {
            int n2 = 0;
            while (n2 < this._n) {
                matrix2.setValue(n, n2, this.get(n, n2) / matrix.get(n, n2));
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public Matrix solve(Matrix matrix) {
        return new QRDecomposition(this).solve(matrix);
    }

    public double getAverageAbsValue() {
        double d = 0.0;
        int n = 0;
        while (n < this._m) {
            int n2 = 0;
            while (n2 < this._n) {
                d += Math.abs(this._matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return d / (double)this._m / (double)this._n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        int n = 0;
        while (n < this._m) {
            stringBuilder.append('(');
            int n2 = 0;
            while (n2 < this._n) {
                stringBuilder.append(this._matrix[n][n2]);
                stringBuilder.append(", ");
                ++n2;
            }
            stringBuilder.append(") ");
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

