/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.outline.NavigationButtons;
import org.freeplane.view.swing.map.outline.OutlineController;
import org.freeplane.view.swing.map.outline.OutlinePane;

class NavigationButtonHider {
    static NavigationButtonHider INSTANCE = new NavigationButtonHider();
    private AWTEventListener mouseMovementDetector;
    private OutlineController outlineController;
    private NavigationButtons navigationButtons;

    NavigationButtonHider() {
    }

    void enable(JComponent buttonParent, final NavigationButtons attachedNavigationButtons) {
        if (this.navigationButtons == attachedNavigationButtons) {
            return;
        }
        if (this.navigationButtons != null) {
            this.navigationButtons.hideNavigationButtons();
            this.outlineController.resetHoveredNode();
        }
        this.disable();
        this.navigationButtons = attachedNavigationButtons;
        final OutlinePane outlinePane = (OutlinePane)SwingUtilities.getAncestorOfClass(OutlinePane.class, buttonParent);
        this.outlineController = outlinePane.getController();
        this.mouseMovementDetector = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    Point eventPoint = new Point(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
                    SwingUtilities.convertPointFromScreen(eventPoint, outlinePane);
                    if (eventPoint.x < 0 || eventPoint.y < 0 || eventPoint.x >= outlinePane.getWidth() || eventPoint.y >= outlinePane.getHeight()) {
                        attachedNavigationButtons.hideNavigationButtons();
                        NavigationButtonHider.this.outlineController.resetHoveredNode();
                        NavigationButtonHider.this.disable();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseMovementDetector, 131120L);
    }

    void disable() {
        if (this.mouseMovementDetector != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseMovementDetector);
            this.outlineController = null;
            this.navigationButtons = null;
            this.mouseMovementDetector = null;
        }
    }
}

