/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm;

import clojure.asm.AnnotationVisitor;
import clojure.asm.Attribute;
import clojure.asm.FieldVisitor;
import clojure.asm.MethodVisitor;
import clojure.asm.ModuleVisitor;
import clojure.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api2) {
        this(api2, null);
    }

    public ClassVisitor(int api2, ClassVisitor classVisitor) {
        if (api2 != 393216 && api2 != 327680 && api2 != 262144 && api2 != 0x1070000) {
            throw new IllegalArgumentException();
        }
        this.api = api2;
        this.cv = classVisitor;
    }

    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version, access, name2, signature2, superName, interfaces);
        }
    }

    public void visitSource(String source2, String debug2) {
        if (this.cv != null) {
            this.cv.visitSource(source2, debug2);
        }
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        if (this.api < 393216) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            return this.cv.visitModule(name2, access, version);
        }
        return null;
    }

    @Deprecated
    public void visitNestHostExperimental(String nestHost) {
        if (this.api < 0x1070000) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            this.cv.visitNestHostExperimental(nestHost);
        }
    }

    public void visitOuterClass(String owner, String name2, String descriptor2) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner, name2, descriptor2);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(descriptor2, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    @Deprecated
    public void visitNestMemberExperimental(String nestMember) {
        if (this.api < 0x1070000) {
            throw new UnsupportedOperationException();
        }
        if (this.cv != null) {
            this.cv.visitNestMemberExperimental(nestMember);
        }
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name2, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name2, String descriptor2, String signature2, Object value) {
        if (this.cv != null) {
            return this.cv.visitField(access, name2, descriptor2, signature2, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature2, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name2, descriptor2, signature2, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

