﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/PersonalizeRequest.h>
#include <aws/personalize/Personalize_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Personalize {
namespace Model {

/**
 */
class DescribeCampaignRequest : public PersonalizeRequest {
 public:
  AWS_PERSONALIZE_API DescribeCampaignRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeCampaign"; }

  AWS_PERSONALIZE_API Aws::String SerializePayload() const override;

  AWS_PERSONALIZE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the campaign.</p>
   */
  inline const Aws::String& GetCampaignArn() const { return m_campaignArn; }
  inline bool CampaignArnHasBeenSet() const { return m_campaignArnHasBeenSet; }
  template <typename CampaignArnT = Aws::String>
  void SetCampaignArn(CampaignArnT&& value) {
    m_campaignArnHasBeenSet = true;
    m_campaignArn = std::forward<CampaignArnT>(value);
  }
  template <typename CampaignArnT = Aws::String>
  DescribeCampaignRequest& WithCampaignArn(CampaignArnT&& value) {
    SetCampaignArn(std::forward<CampaignArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_campaignArn;
  bool m_campaignArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
