/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

class Type5ShadingContext
extends GouraudShadingContext {
    private static final Log LOG = LogFactory.getLog(Type5ShadingContext.class);

    public Type5ShadingContext(PDShadingType5 shading, ColorModel cm, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, cm, xform, ctm, pageHeight, dBounds);
        LOG.debug("Type5ShadingContext");
        xform.scale(1.0, -1.0);
        xform.translate(0.0, -pageHeight);
        this.triangleList = this.getTriangleList(xform, ctm);
        this.pixelTable = this.calcPixelTable();
    }

    private ArrayList<ShadedTriangle> getTriangleList(AffineTransform xform, Matrix ctm) throws IOException {
        ArrayList<ShadedTriangle> list = new ArrayList<ShadedTriangle>();
        PDShadingType5 latticeTriangleShadingType = (PDShadingType5)this.shading;
        COSDictionary cosDictionary = latticeTriangleShadingType.getCOSDictionary();
        PDRange rangeX = latticeTriangleShadingType.getDecodeForParameter(0);
        PDRange rangeY = latticeTriangleShadingType.getDecodeForParameter(1);
        int numPerRow = latticeTriangleShadingType.getVerticesPerRow();
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = latticeTriangleShadingType.getDecodeForParameter(2 + i);
        }
        ArrayList<Vertex> vlist = new ArrayList<Vertex>();
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        COSStream cosStream = (COSStream)cosDictionary;
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());
        try {
            while (true) {
                Vertex p = this.readVertex(mciis, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform);
                vlist.add(p);
            }
        }
        catch (EOFException ex) {
            int j;
            int i;
            int sz = vlist.size();
            int rowNum = sz / numPerRow;
            Vertex[][] latticeArray = new Vertex[rowNum][numPerRow];
            if (rowNum < 2) {
                return this.triangleList;
            }
            for (i = 0; i < rowNum; ++i) {
                for (j = 0; j < numPerRow; ++j) {
                    latticeArray[i][j] = (Vertex)vlist.get(i * numPerRow + j);
                }
            }
            for (i = 0; i < rowNum - 1; ++i) {
                for (j = 0; j < numPerRow - 1; ++j) {
                    Point2D[] ps = new Point2D[]{latticeArray[i][j].point, latticeArray[i][j + 1].point, latticeArray[i + 1][j].point};
                    float[][] cs = new float[][]{latticeArray[i][j].color, latticeArray[i][j + 1].color, latticeArray[i + 1][j].color};
                    list.add(new ShadedTriangle(ps, cs));
                    ps = new Point2D[]{latticeArray[i][j + 1].point, latticeArray[i + 1][j].point, latticeArray[i + 1][j + 1].point};
                    cs = new float[][]{latticeArray[i][j + 1].color, latticeArray[i + 1][j].color, latticeArray[i + 1][j + 1].color};
                    list.add(new ShadedTriangle(ps, cs));
                }
            }
            return list;
        }
    }
}

