/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CMAPEncodingEntry;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TTFSubFont;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.MacOSRomanEncoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.util.ResourceLoader;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDTrueTypeFont.class);
    private static final int START_RANGE_F000 = 61440;
    private static final int START_RANGE_F100 = 61696;
    private static final int START_RANGE_F200 = 61952;
    private CMAPEncodingEntry cmapWinUnicode = null;
    private CMAPEncodingEntry cmapWinSymbol = null;
    private CMAPEncodingEntry cmapMacintoshSymbol = null;
    private boolean cmapInitialized = false;
    private TrueTypeFont trueTypeFont = null;
    private HashMap<Integer, Float> advanceWidths = new HashMap();
    public static final String UNKNOWN_FONT = "UNKNOWN_FONT";
    private Font awtFont = null;
    private static Properties externalFonts = new Properties();
    private static Map<String, TrueTypeFont> loadedExternalFonts = new HashMap<String, TrueTypeFont>();

    public PDTrueTypeFont() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TRUE_TYPE);
    }

    public PDTrueTypeFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.ensureFontDescriptor();
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, String file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new File(file));
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, File file) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, new FileInputStream(file));
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream stream) throws IOException {
        return PDTrueTypeFont.loadTTF(doc, stream, new WinAnsiEncoding());
    }

    public static PDTrueTypeFont loadTTF(PDDocument doc, InputStream stream, Encoding enc) throws IOException {
        PDStream fontStream = new PDStream(doc, stream, false);
        fontStream.getStream().setInt(COSName.LENGTH1, fontStream.getByteArray().length);
        fontStream.addCompression();
        return PDTrueTypeFont.loadTTF(fontStream, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDTrueTypeFont loadTTF(PDStream fontStream, Encoding enc) throws IOException {
        PDTrueTypeFont retval = new PDTrueTypeFont();
        retval.setFontEncoding(enc);
        retval.setEncoding(enc.getCOSObject());
        PDFontDescriptorDictionary fd = new PDFontDescriptorDictionary();
        retval.setFontDescriptor(fd);
        fd.setFontFile2(fontStream);
        InputStream stream = fontStream.createInputStream();
        try {
            retval.loadDescriptorDictionary(fd, stream);
        }
        finally {
            stream.close();
        }
        return retval;
    }

    private void ensureFontDescriptor() throws IOException {
        if (this.getFontDescriptor() == null) {
            PDFontDescriptorDictionary fdd = new PDFontDescriptorDictionary();
            this.setFontDescriptor(fdd);
            InputStream ttfData = this.getExternalTTFData();
            if (ttfData != null) {
                try {
                    this.loadDescriptorDictionary(fdd, ttfData);
                }
                finally {
                    ttfData.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptorDictionary(PDFontDescriptorDictionary fd, InputStream ttfData) throws IOException {
        TrueTypeFont ttf = null;
        try {
            TTFParser parser = new TTFParser();
            ttf = parser.parseTTF(ttfData);
            NamingTable naming = ttf.getNaming();
            List records = naming.getNameRecords();
            for (int i = 0; i < records.size(); ++i) {
                NameRecord nr = (NameRecord)records.get(i);
                if (nr.getNameId() == 6) {
                    this.setBaseFont(nr.getString());
                    fd.setFontName(nr.getString());
                    continue;
                }
                if (nr.getNameId() != 1) continue;
                fd.setFontFamily(nr.getString());
            }
            OS2WindowsMetricsTable os2 = ttf.getOS2Windows();
            boolean isSymbolic = false;
            switch (os2.getFamilyClass()) {
                case 12: {
                    isSymbolic = true;
                    break;
                }
                case 10: {
                    fd.setScript(true);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    fd.setSerif(true);
                    break;
                }
            }
            switch (os2.getWidthClass()) {
                case 1: {
                    fd.setFontStretch("UltraCondensed");
                    break;
                }
                case 2: {
                    fd.setFontStretch("ExtraCondensed");
                    break;
                }
                case 3: {
                    fd.setFontStretch("Condensed");
                    break;
                }
                case 4: {
                    fd.setFontStretch("SemiCondensed");
                    break;
                }
                case 5: {
                    fd.setFontStretch("Normal");
                    break;
                }
                case 6: {
                    fd.setFontStretch("SemiExpanded");
                    break;
                }
                case 7: {
                    fd.setFontStretch("Expanded");
                    break;
                }
                case 8: {
                    fd.setFontStretch("ExtraExpanded");
                    break;
                }
                case 9: {
                    fd.setFontStretch("UltraExpanded");
                    break;
                }
            }
            fd.setFontWeight(os2.getWeightClass());
            fd.setSymbolic(isSymbolic);
            fd.setNonSymbolic(!isSymbolic);
            HeaderTable header = ttf.getHeader();
            PDRectangle rect = new PDRectangle();
            float scaling = 1000.0f / (float)header.getUnitsPerEm();
            rect.setLowerLeftX((float)header.getXMin() * scaling);
            rect.setLowerLeftY((float)header.getYMin() * scaling);
            rect.setUpperRightX((float)header.getXMax() * scaling);
            rect.setUpperRightY((float)header.getYMax() * scaling);
            fd.setFontBoundingBox(rect);
            HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
            fd.setAscent((float)hHeader.getAscender() * scaling);
            fd.setDescent((float)hHeader.getDescender() * scaling);
            GlyphTable glyphTable = ttf.getGlyph();
            GlyphData[] glyphs = glyphTable.getGlyphs();
            PostScriptTable ps = ttf.getPostScript();
            fd.setFixedPitch(ps.getIsFixedPitch() > 0L);
            fd.setItalicAngle(ps.getItalicAngle());
            String[] names = ps.getGlyphNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].equals("H")) {
                        fd.setCapHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
                    }
                    if (!names[i].equals("x")) continue;
                    fd.setXHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
                }
            }
            fd.setStemV(fd.getFontBoundingBox().getWidth() * 0.13f);
            CMAPTable cmapTable = ttf.getCMAP();
            CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
            CMAPEncodingEntry uniMap = null;
            for (int i = 0; i < cmaps.length; ++i) {
                int platformEncoding;
                if (cmaps[i].getPlatformId() != 3 || 1 != (platformEncoding = cmaps[i].getPlatformEncodingId())) continue;
                uniMap = cmaps[i];
                break;
            }
            Map<Integer, String> codeToName = this.getFontEncoding().getCodeToNameMap();
            int firstChar = Collections.min(codeToName.keySet());
            int lastChar = Collections.max(codeToName.keySet());
            HorizontalMetricsTable hMet = ttf.getHorizontalMetrics();
            int[] widthValues = hMet.getAdvanceWidth();
            boolean isMonospaced = fd.isFixedPitch() || widthValues.length == 1;
            int nWidths = lastChar - firstChar + 1;
            ArrayList<Float> widths = new ArrayList<Float>(nWidths);
            int defaultWidth = Math.round((float)widthValues[0] * scaling);
            for (int i = 0; i < nWidths; ++i) {
                widths.add(Float.valueOf(defaultWidth));
            }
            WinAnsiEncoding glyphlist = WinAnsiEncoding.INSTANCE;
            for (Map.Entry<Integer, String> e : codeToName.entrySet()) {
                String name = e.getValue();
                String c = glyphlist.getCharacter(name);
                int charCode = c.codePointAt(0);
                int gid = uniMap.getGlyphId(charCode);
                if (gid == 0) continue;
                if (isMonospaced) {
                    widths.set(e.getKey() - firstChar, Float.valueOf(defaultWidth));
                    continue;
                }
                widths.set(e.getKey() - firstChar, Float.valueOf(Math.round((float)widthValues[gid] * scaling)));
            }
            this.setWidths(widths);
            this.setFirstChar(firstChar);
            this.setLastChar(lastChar);
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Font getawtFont() throws IOException {
        PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
        if (this.awtFont == null) {
            PDStream ff2Stream = fd.getFontFile2();
            if (ff2Stream != null) {
                InputStream is = null;
                try {
                    is = ff2Stream.createInputStream();
                    this.awtFont = Font.createFont(0, is);
                }
                catch (FontFormatException f) {
                    try {
                        byte[] fontData = this.rebuildTTF(fd, ff2Stream.createInputStream());
                        if (fontData != null) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(fontData);
                            this.awtFont = Font.createFont(0, bais);
                        }
                    }
                    catch (FontFormatException e) {
                        log.info("Can't read the embedded font " + fd.getFontName());
                    }
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
                if (this.awtFont == null) {
                    if (fd.getFontName() != null) {
                        this.awtFont = FontManager.getAwtFont(fd.getFontName());
                    }
                    if (this.awtFont != null) {
                        log.info("Using font " + this.awtFont.getName() + " instead");
                    }
                    this.setIsFontSubstituted(true);
                }
            } else {
                if (fd.getFontName() != null) {
                    this.awtFont = FontManager.getAwtFont(fd.getFontName());
                }
                if (this.awtFont == null) {
                    log.info("Can't find the specified font " + fd.getFontName());
                    TrueTypeFont ttf = this.getExternalFontFile2(fd);
                    if (ttf != null) {
                        try {
                            this.awtFont = Font.createFont(0, ttf.getOriginalData());
                        }
                        catch (FontFormatException f) {
                            log.info("Can't read the external fontfile " + fd.getFontName());
                        }
                    }
                }
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info("Using font " + this.awtFont.getName() + " instead");
                this.setIsFontSubstituted(true);
            }
        }
        return this.awtFont;
    }

    private byte[] rebuildTTF(PDFontDescriptorDictionary fd, InputStream inputStream) throws IOException {
        if (this.getFontEncoding() instanceof WinAnsiEncoding) {
            TTFParser ttfParser = new TTFParser(true);
            TrueTypeFont ttf = ttfParser.parseTTF(inputStream);
            TTFSubFont ttfSub = new TTFSubFont(ttf, "PDFBox-Rebuild");
            for (int i = this.getFirstChar(); i <= this.getLastChar(); ++i) {
                ttfSub.addCharCode(i);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ttfSub.writeToStream((OutputStream)baos);
            return baos.toByteArray();
        }
        return null;
    }

    private InputStream getExternalTTFData() throws IOException {
        String ttfResource = externalFonts.getProperty(UNKNOWN_FONT);
        String baseFont = this.getBaseFont();
        if (baseFont != null && externalFonts.containsKey(baseFont)) {
            ttfResource = externalFonts.getProperty(baseFont);
        }
        return ttfResource != null ? ResourceLoader.loadResource(ttfResource) : null;
    }

    private TrueTypeFont getExternalFontFile2(PDFontDescriptorDictionary fd) throws IOException {
        String baseFont;
        TrueTypeFont retval = null;
        if (fd != null && (retval = org.apache.fontbox.util.FontManager.findTTFont((String)(baseFont = this.getBaseFont()))) == null) {
            String fontResource = externalFonts.getProperty(UNKNOWN_FONT);
            if (baseFont != null && externalFonts.containsKey(baseFont)) {
                fontResource = externalFonts.getProperty(baseFont);
            }
            if (fontResource != null && (retval = loadedExternalFonts.get(baseFont)) == null) {
                TTFParser ttfParser = new TTFParser();
                InputStream fontStream = ResourceLoader.loadResource(fontResource);
                if (fontStream == null) {
                    throw new IOException("Error missing font resource '" + externalFonts.get(baseFont) + "'");
                }
                retval = ttfParser.parseTTF(fontStream);
                loadedExternalFonts.put(baseFont, retval);
            }
        }
        return retval;
    }

    public TrueTypeFont getTTFFont() throws IOException {
        if (this.trueTypeFont == null) {
            PDStream ff2Stream;
            PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
            if (fd != null && (ff2Stream = fd.getFontFile2()) != null) {
                TTFParser ttfParser = new TTFParser(true);
                this.trueTypeFont = ttfParser.parseTTF(ff2Stream.createInputStream());
            }
            if (this.trueTypeFont == null) {
                this.trueTypeFont = org.apache.fontbox.util.FontManager.findTTFont((String)this.getBaseFont());
            }
        }
        return this.trueTypeFont;
    }

    @Override
    public void clear() {
        super.clear();
        this.cmapWinUnicode = null;
        this.cmapWinSymbol = null;
        this.cmapMacintoshSymbol = null;
        this.trueTypeFont = null;
        if (this.advanceWidths != null) {
            this.advanceWidths.clear();
        }
    }

    @Override
    public float getFontWidth(int charCode) {
        float width = super.getFontWidth(charCode);
        if (width <= 0.0f) {
            if (this.advanceWidths.containsKey(charCode)) {
                width = this.advanceWidths.get(charCode).floatValue();
            } else {
                TrueTypeFont ttf = null;
                try {
                    ttf = this.getTTFFont();
                    if (ttf != null) {
                        int code = this.getGlyphcode(charCode);
                        width = ttf.getAdvanceWidth(code);
                        int unitsPerEM = ttf.getUnitsPerEm();
                        if (unitsPerEM != 1000) {
                            width *= 1000.0f / (float)unitsPerEM;
                        }
                    }
                }
                catch (IOException exception) {
                    width = 250.0f;
                }
                this.advanceWidths.put(charCode, Float.valueOf(width));
            }
        }
        return width;
    }

    private int getGlyphcode(int code) {
        int result;
        block18: {
            this.extractCMaps();
            result = 0;
            if (this.getFontEncoding() != null && !this.isSymbolicFont()) {
                try {
                    String charactername = this.getFontEncoding().getName(code);
                    if (charactername == null) break block18;
                    if (this.cmapWinUnicode != null) {
                        String unicode = Encoding.getCharacterForName(charactername);
                        if (unicode != null) {
                            result = unicode.codePointAt(0);
                        }
                        result = this.cmapWinUnicode.getGlyphId(result);
                    } else if (this.cmapMacintoshSymbol != null && MacOSRomanEncoding.INSTANCE.hasCodeForName(charactername)) {
                        result = MacOSRomanEncoding.INSTANCE.getCode(charactername);
                        result = this.cmapMacintoshSymbol.getGlyphId(result);
                    } else if (this.cmapWinSymbol != null) {
                        result = this.cmapWinSymbol.getGlyphId(code);
                    }
                }
                catch (IOException exception) {
                    log.error("Caught an exception getGlyhcode: " + exception);
                }
            } else if (this.getFontEncoding() == null || this.isSymbolicFont()) {
                if (this.cmapWinSymbol != null) {
                    result = this.cmapWinSymbol.getGlyphId(code);
                    if (code >= 0 && code <= 255) {
                        if (result == 0) {
                            result = this.cmapWinSymbol.getGlyphId(code + 61440);
                        }
                        if (result == 0) {
                            result = this.cmapWinSymbol.getGlyphId(code + 61696);
                        }
                        if (result == 0) {
                            result = this.cmapWinSymbol.getGlyphId(code + 61952);
                        }
                    }
                } else if (this.cmapMacintoshSymbol != null) {
                    result = this.cmapMacintoshSymbol.getGlyphId(code);
                }
            }
        }
        return result;
    }

    private void extractCMaps() {
        if (!this.cmapInitialized) {
            try {
                this.getTTFFont();
            }
            catch (IOException exception) {
                log.error("Can't read the true type font", exception);
            }
            CMAPTable cmapTable = this.trueTypeFont.getCMAP();
            if (cmapTable != null) {
                CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
                for (int i = 0; i < cmaps.length; ++i) {
                    if (cmaps[i] == null) continue;
                    if (3 == cmaps[i].getPlatformId()) {
                        if (1 == cmaps[i].getPlatformEncodingId()) {
                            this.cmapWinUnicode = cmaps[i];
                            continue;
                        }
                        if (0 != cmaps[i].getPlatformEncodingId()) continue;
                        this.cmapWinSymbol = cmaps[i];
                        continue;
                    }
                    if (1 != cmaps[i].getPlatformId() || 0 != cmaps[i].getPlatformEncodingId()) continue;
                    this.cmapMacintoshSymbol = cmaps[i];
                }
            }
            this.cmapInitialized = true;
        }
    }

    static {
        try {
            ResourceLoader.loadProperties("org/apache/pdfbox/resources/PDFBox_External_Fonts.properties", externalFonts);
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading font resources", io);
        }
    }
}

