import os
import sys


def _windows_dll_path():
    _catalyst_python_path = "lib/python3.14/site-packages/catalyst"
    _catalyst_dll_path = "bin"
    # Compute the DLL path based on the location of the file and traversing up
    # the installation prefix to append the DLL path.
    _catalyst_dll_directory = os.path.dirname(os.path.abspath(__file__))
    # Loop while we have components to remove.
    while _catalyst_python_path not in ("", ".", "/"):
        # Strip a directory away.
        _catalyst_python_path = os.path.dirname(_catalyst_python_path)
        _catalyst_dll_directory = os.path.dirname(_catalyst_dll_directory)
    _catalyst_dll_directory = os.path.join(_catalyst_dll_directory, _catalyst_dll_path)
    if os.path.exists(_catalyst_dll_directory):
        # We never remove this path; it is required for CATALYST to work and there's
        # no scope where we can easily remove the directory again.
        _ = os.add_dll_directory(_catalyst_dll_directory)


if sys.version_info >= (3, 8) and sys.platform == "win32":
    _windows_dll_path()

from .catalyst_python import *
