/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.TransitGateway;

public class DescribeTransitGatewaysIterable
implements SdkIterable<DescribeTransitGatewaysResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewaysIterable(Ec2Client client, DescribeTransitGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewaysResponseFetcher();
    }

    public Iterator<DescribeTransitGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGateway> transitGateways() {
        Function<DescribeTransitGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGateways() != null) {
                return response.transitGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewaysResponse> {
        private DescribeTransitGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewaysResponse nextPage(DescribeTransitGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewaysIterable.this.client.describeTransitGateways(DescribeTransitGatewaysIterable.this.firstRequest);
            }
            return DescribeTransitGatewaysIterable.this.client.describeTransitGateways((DescribeTransitGatewaysRequest)((Object)DescribeTransitGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

