/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.StoreImageTaskResult;

public class DescribeStoreImageTasksPublisher
implements SdkPublisher<DescribeStoreImageTasksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeStoreImageTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStoreImageTasksPublisher(Ec2AsyncClient client, DescribeStoreImageTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStoreImageTasksPublisher(Ec2AsyncClient client, DescribeStoreImageTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStoreImageTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStoreImageTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StoreImageTaskResult> storeImageTaskResults() {
        Function<DescribeStoreImageTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.storeImageTaskResults() != null) {
                return response.storeImageTaskResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStoreImageTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStoreImageTasksResponseFetcher
    implements AsyncPageFetcher<DescribeStoreImageTasksResponse> {
        private DescribeStoreImageTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStoreImageTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStoreImageTasksResponse> nextPage(DescribeStoreImageTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeStoreImageTasksPublisher.this.client.describeStoreImageTasks(DescribeStoreImageTasksPublisher.this.firstRequest);
            }
            return DescribeStoreImageTasksPublisher.this.client.describeStoreImageTasks((DescribeStoreImageTasksRequest)((Object)DescribeStoreImageTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

