/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse;
import software.amazon.awssdk.services.ec2.model.Subscription;

public class DescribeAwsNetworkPerformanceMetricSubscriptionsIterable
implements SdkIterable<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> {
    private final Ec2Client client;
    private final DescribeAwsNetworkPerformanceMetricSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAwsNetworkPerformanceMetricSubscriptionsIterable(Ec2Client client, DescribeAwsNetworkPerformanceMetricSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher
    implements SyncPageFetcher<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> {
        private DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAwsNetworkPerformanceMetricSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAwsNetworkPerformanceMetricSubscriptionsResponse nextPage(DescribeAwsNetworkPerformanceMetricSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAwsNetworkPerformanceMetricSubscriptionsIterable.this.client.describeAwsNetworkPerformanceMetricSubscriptions(DescribeAwsNetworkPerformanceMetricSubscriptionsIterable.this.firstRequest);
            }
            return DescribeAwsNetworkPerformanceMetricSubscriptionsIterable.this.client.describeAwsNetworkPerformanceMetricSubscriptions((DescribeAwsNetworkPerformanceMetricSubscriptionsRequest)((Object)DescribeAwsNetworkPerformanceMetricSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

